package com.ruoyi.party.service.api;

import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.party.domain.PartyMember;
import com.ruoyi.party.domain.vo.PartyMemberVo;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;

import java.util.List;
import java.util.Map;

/**
 * 党员Service接口
 *
 * @author ruoyi
 * @date 2024-05-17
 */
public interface IPartyMemberService
{
    /**
     * 查询党员
     *
     * @param id 党员主键
     * @return 党员
     */
    public PartyMemberVo selectPartyMemberById(Long id);

    /**
     * 查询党员列表
     *
     * @param partyMember 党员
     * @return 党员集合
     */
    public List<PartyMember> selectPartyMemberList(PartyMember partyMember);

    /**
     * 新增党员
     *
     * @param partyMember 党员
     * @return 结果
     */
    public int insertPartyMember(PartyMember partyMember);

    /**
     * 修改党员
     *
     * @param partyMember 党员
     * @return 结果
     */
    public int updatePartyMember(PartyMember partyMember);

    /**
     * 批量删除党员
     *
     * @param ids 需要删除的党员主键集合
     * @return 结果
     */
    public int deletePartyMemberByIds(String[] ids);

    /**
     * 删除党员信息
     *
     * @param id 党员主键
     * @return 结果
     */
    public int deletePartyMemberById(String id);


    Integer getPartyCount();

    List<Map<String,String>> getXLFB(String orgId);

    //党龄
    List<Map<String,String>> getDl(String orgId);

    void importExcel(Workbook workbook, Map<String, SysDictData> treeMap, Map<String, SysDictData> educationMap);

    HSSFWorkbook exportTemplate();

    List<PartyMemberVo> convertToVo(List<PartyMember> memberList);

    List<String> getAgeList();
}
