package com.ruoyi.system.domain.task.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
* 工单 隐患矛盾
* @TableName tk_common_yinhuan
*/
@Data
public class TkCommonYinhuanVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("事件名称")
    private String title;
    @ApiModelProperty("事发时间")
    private LocalDateTime happenTime;
    @ApiModelProperty("事发地点")
    private String address;
    @ApiModelProperty("详情")
    private String description;
    @ApiModelProperty("来源部门")
    private Long depId;
    @ApiModelProperty("危险程度")
    private String dangerFlag;
    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("修改时间")
    private LocalDateTime updateTime;
    @ApiModelProperty("来源部门名称")
    private String depName;
    @ApiModelProperty("绑定对象")
    private List<Bind> bindList;

    @Data
    @ApiModel("绑定对象")
    public static class Bind{
        @ApiModelProperty("关联对象类型")
        private String bindType;
        @ApiModelProperty("关联对象id")
        private String bindId;
        @ApiModelProperty("关联对象名称")
        private String bindName;
        private Long yinhuanId;
    }
}
