package com.ruoyi.system.mapper.publicservice;


import java.util.List;
import com.ruoyi.common.utils.sql.Query;

/**
 * 基础dao
 * @author zcl<yczclcn@163.com>
 */
public interface PSPublicServiceBaseMapper<T> {

	/**
	 * 新增
	 * @param t
	 * @return
	 */
	int save(T t);

	/**
	 * 批量新增
	 * @param items
	 * @return
	 */
	int batchSave(List<T> items);

	/**
	 * 查询详情
	 * @param t
	 * @return
	 */
	T getObject(T t);

	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	T getObjectById(Object id);

	/**
	 * 更新
	 * @param t
	 * @return
	 */
	int update(T t);


	/**
	 * 删除
	 * @param id
	 * @return
	 */
	int remove(Object id);

	int remove(Query query);

	int remveByLabelId(Object id);

	/**
	 * 逻辑删除
	 * @param id
	 * @return
	 */
	int removeLogic(Object id);

	/**
	 * 批量删除
	 * @param id
	 * @return
	 */
	int batchRemove(Object[] id);

	int batchRemove(Object id);

	int batchRemove(List<T> t);

	int batchRemove(Query query);

	/**
	 * 批量逻辑删除
	 * @param id
	 * @return
	 */
	int batchRemoveLogic(Object[] id);

	int batchRemoveLogic(Object id);

	int batchRemoveLogic(List<T> t);

	/**
	 * 查询列表
	 * @param t
	 * @return
	 */
	List<T> listForPage(T t);

	/**
	 * 查询列表
	 * @param t
	 * @return
	 */
	List<T> list(T t);

	/**
	 * 查询列表
	 * @return
	 */
	List<T> list();

	/**
	 * 查询列表
	 * @param t
	 * @return
	 */
	List<T> listCom(T t);

	/**
	 * 查询列表
	 * @return
	 */
	List<T> listCom();

	/**
	 * 获取远程列表
	 * @param t
	 * @return
	 */
	List<T> listRemote(T t);
	/**
	 * 统计
	 * @return
	 */
	int countTotal();

	/**
	 * 清空表
	 */
	void truncate();

	/**
	 * 查询列表
	 * @param query
	 * @return
	 */
	List<T> listForPage(Query query);

	/**
	 * 查询列表
	 * @param query
	 * @return
	 */
	List<T> list(Query query);

}
