package com.ruoyi.party.service.api;

import com.ruoyi.party.domain.ClickNumber;
import com.ruoyi.party.domain.vo.ClickNumberStatisticsVo;

import java.util.List;

/**
 * 点击次数Service接口
 * 
 * @author ruoyi
 * @date 2024-05-24
 */
public interface IClickNumberService 
{
    /**
     * 查询点击次数
     * 
     * @param id 点击次数主键
     * @return 点击次数
     */
    public ClickNumber selectClickNumberById(Long id);

    /**
     * 查询点击次数列表
     * 
     * @param clickNumber 点击次数
     * @return 点击次数集合
     */
    public List<ClickNumber> selectClickNumberList(ClickNumber clickNumber);

    /**
     * 新增点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    public int insertClickNumber(ClickNumber clickNumber);

    /**
     * 修改点击次数
     * 
     * @param clickNumber 点击次数
     * @return 结果
     */
    public int updateClickNumber(ClickNumber clickNumber);

    /**
     * 批量删除点击次数
     * 
     * @param ids 需要删除的点击次数主键集合
     * @return 结果
     */
    public int deleteClickNumberByIds(Long[] ids);

    /**
     * 删除点击次数信息
     * 
     * @param id 点击次数主键
     * @return 结果
     */
    public int deleteClickNumberById(Long id);

    ClickNumberStatisticsVo getClickNumberStatistics(String type, String businessKey);
}
