package com.ruoyi.web.controller.grid;

import com.alibaba.fastjson2.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridItemDaily;
import com.ruoyi.system.domain.grid.GridItemDailyExample;
import com.ruoyi.system.service.grid.GridItemDailyFacadeService;
import com.ruoyi.system.service.grid.GridItemDailyService;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @Auther: hxc
 * @Date: 2019/2/28 0028 14:09
 * @Description: 网格信息表
 */
@Api(tags = "网格管理 - 日常事项")
@RestController
@RequestMapping("/api/grid/itemDaily")
public class GridItemDailyController {

    @Autowired
    private GridItemDailyFacadeService gridItemDailyFacadeService;
    @Autowired
    private GridItemDailyService gridItemDailyService;

    //对内接口
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ResponseBody
    public String list(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                       @RequestParam("sxbm") String sxbm, @RequestParam("sxmc") String sxmc) {
        AjaxResult result = new AjaxResult();
        gridItemDailyFacadeService.getRoles(sxbm, sxmc, pageNum, pageSize, result);
        return JSON.toJSONString(result);
    }

    @RequestMapping(value = "/list_search", method = RequestMethod.GET)
    @ResponseBody
    public String listSearch(@RequestParam("pageNum") int pageNum, @RequestParam("pageSize") int pageSize,
                             @RequestParam("sxbm") String sxbm, @RequestParam("sxmc") String sxmc,
                             @RequestParam("sjfl") String sjfl) {
        AjaxResult result = new AjaxResult();
        gridItemDailyFacadeService.getSearch(sjfl, sxbm, sxmc,  pageNum, pageSize, result);
        return JSON.toJSONString(result);
    }


    @RequestMapping(value = "/add", method = RequestMethod.POST)
    @ResponseBody
    public String add(@RequestBody GridItemDaily itemDaily) {
        itemDaily.setId(UUID.randomUUID().toString());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
        itemDaily.setCreateTime(df.format(new Date()));
        GridItemDailyExample example = new GridItemDailyExample();
        GridItemDailyExample.Criteria criteria = example.createCriteria();
        //判断是否有根节点
        criteria.andSjflIsNull();
        int count = gridItemDailyService.countByExample(example);
        if (count == 0 || StringUtils.isNotEmpty(itemDaily.getSjfl())) {
            int result = gridItemDailyService.insert(itemDaily);
            if (result == 1) {
                return JSON.toJSONString(AjaxResult.success("success", itemDaily));
            } else {
                return JSON.toJSONString(AjaxResult.error(400, "fail"));
            }
        } else {
            return JSON.toJSONString(AjaxResult.error(300, "已存在根节点！"));
        }

    }


    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public String delete(@RequestParam String id) {
        int result = gridItemDailyService.deleteByStringPrimaryKey(id);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", id));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "fail"));
        }
    }


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public String update(@RequestBody GridItemDaily itemDaily) {
        int result = gridItemDailyService.updateByPrimaryKeySelective(itemDaily);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", itemDaily));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "fail"));
        }
    }


    @RequestMapping(value = "/treeNode", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> treeNode(@RequestParam(value = "sxbm", required = false) String sxbm) {
        try {
            List<Map<String, Object>> str = gridItemDailyFacadeService.getTreeNode(sxbm);
            return str;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value = "/getSxbm", method = RequestMethod.GET)
    @ResponseBody
    public String getSxbm(@RequestParam("sxbm") String sxbm) {
        String code = gridItemDailyFacadeService.getSxbm(sxbm);
        String name = gridItemDailyFacadeService.getSxmc(sxbm);

        return JSON.toJSONString(AjaxResult.success("success", code + ":" + name));
    }

    @RequestMapping(value = "/addList", method = RequestMethod.GET)
    @ResponseBody
    public String addList(@RequestParam("createBy") String createBy) {
        int num = gridItemDailyFacadeService.rcsxbAddList(createBy);
        if (num == 1) {
            return JSON.toJSONString(AjaxResult.success("success", "导入成功"));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "导入失败"));
        }

    }

    @RequestMapping(value = "/drsxList", method = RequestMethod.GET)
    @ResponseBody
    public String drsxList(@RequestParam("sxbm") String sxbm,
                           @RequestParam("createBy") String createBy, @RequestParam("drnr") String drnr) {
        drnr = drnr.replaceAll("\"", "");
        drnr = drnr.replaceAll("\\]", "");
        drnr = drnr.replaceAll("\\[", "");
        String nums[] = drnr.split(",");
        int result = gridItemDailyFacadeService.rcsxdr(sxbm, createBy, nums);
        if (result == 1) {
            return JSON.toJSONString(AjaxResult.success("success", "导入成功"));
        } else {
            return JSON.toJSONString(AjaxResult.error(400, "导入失败"));
        }
    }


    @RequestMapping(value = "/delXjSxbm", method = RequestMethod.GET)
    @ResponseBody
    public String delXjSxbm(@RequestParam("sxbm") String sxbm) {
        List<GridItemDaily> GridItemDaily = gridItemDailyFacadeService.DelXjSxbm(sxbm);
        int num = 0;
        if (GridItemDaily.size() > 0) {
            num = 1;
        }
        return JSON.toJSONString(AjaxResult.success("success", num));
    }


    //对外接口
    @RequestMapping(value = "/dw/rcsxList", method = RequestMethod.GET)
    @ResponseBody
    public String getDwRcsxList(@RequestParam(value = "sxbm", required = false) String sxbm) {
        try {
            AjaxResult result = new AjaxResult();
            List<Map<String, Object>> str = gridItemDailyFacadeService.getDwItemDailyList(sxbm, result);
            return JSON.toJSONString(AjaxResult.success("success", str));
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(400, e.toString()));
        }
    }

    /**
     * 层级级联日常事项，包含最外面一层
     * @return
     */
    @GetMapping("/eventLevelTree")
    @ResponseBody
    public AjaxResult getEventLevelTree(String sxbm){
        return AjaxResult.success(gridItemDailyFacadeService.getRcsxLevelTreeList(sxbm));
    }

}
