package com.ruoyi.web.controller.form;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.form.MdFormCategory;
import com.ruoyi.system.domain.form.params.FormQuery;
import com.ruoyi.system.service.form.FormCategoryManager;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 表单分类
 */
@Api(tags = "在线表单 - 表单分类")
@RestController
@RequestMapping("/api/form/category")
public class FormCategoryController extends BaseController {

    @Autowired
    private FormCategoryManager formCategoryManager;

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //表单分类  查询不分页。
     * @Date 10:36 2020/8/17
     * @Param [query]
     **/
    @GetMapping(value = "/list")
    @ResponseBody
    public AjaxResult list(FormQuery formQuery) {
        try {
            return AjaxResult.success(formCategoryManager.query(formQuery));
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * 所有表单分类
     * @return
     */
    @GetMapping(value = "/listAll")
    @ResponseBody
    public AjaxResult listAll() {
        try {
            return AjaxResult.success(formCategoryManager.categoryList());
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //保存/更新
     * @Date 13:06 2020/8/17
     * @Param [mdFormCategory]
     **/
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult saveOrUpdateSetting(@RequestBody MdFormCategory mdFormCategory) {
        try {
            return AjaxResult.success(formCategoryManager.saveOrUpdate(mdFormCategory));

        } catch (RuntimeException e1) {
            return AjaxResult.build(600, e1.getMessage(), e1.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

    @RequestMapping(value = "/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public AjaxResult deleteById(@RequestBody MdFormCategory mdFormCategory) {
        try {
            int count = formCategoryManager.deleteById(mdFormCategory);
            if (count > 0) {
                return AjaxResult.success("删除成功");
            }
            return AjaxResult.build(500, "删除失败", "删除失败");
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.build(500, "服务器内部错误", e.getMessage());
        }
    }

}

