/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.MBeanAttributeVO;
import com.taobao.arthas.core.command.model.MBeanModel;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanView
extends ResultView<MBeanModel> {
    @Override
    public void draw(CommandProcess process, MBeanModel result) {
        if (result.getMbeanNames() != null) {
            this.drawMBeanNames(process, result.getMbeanNames());
        } else if (result.getMbeanMetadata() != null) {
            this.drawMBeanMetadata(process, result.getMbeanMetadata());
        } else if (result.getMbeanAttribute() != null) {
            this.drawMBeanAttributes(process, result.getMbeanAttribute());
        }
    }

    private void drawMBeanAttributes(CommandProcess process, Map<String, List<MBeanAttributeVO>> mbeanAttributeMap) {
        for (Map.Entry<String, List<MBeanAttributeVO>> entry : mbeanAttributeMap.entrySet()) {
            String objectName = entry.getKey();
            List<MBeanAttributeVO> attributeVOList = entry.getValue();
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            table.row(true, "OBJECT_NAME", objectName);
            table.row(true, Element.label("NAME").style(Decoration.bold.bold()), Element.label("VALUE").style(Decoration.bold.bold()));
            for (MBeanAttributeVO attributeVO : attributeVOList) {
                String valueStr;
                String attributeName = attributeVO.getName();
                if (attributeVO.getError() != null) {
                    valueStr = RenderUtil.render(new LabelElement(attributeVO.getError()).style(Decoration.bold_off.fg(Color.red)));
                } else {
                    List<Object> value = attributeVO.getValue();
                    if (value instanceof String[]) {
                        value = Arrays.asList((String[])value);
                    } else if (value instanceof Integer[]) {
                        value = Arrays.asList((Integer[])value);
                    } else if (value instanceof Long[]) {
                        value = Arrays.asList((Long[])value);
                    } else if (value instanceof int[]) {
                        value = this.convertArrayToList((int[])value);
                    } else if (value instanceof long[]) {
                        value = this.convertArrayToList((long[])value);
                    }
                    valueStr = String.valueOf(value);
                }
                table.row(attributeName, valueStr);
            }
            process.write(RenderUtil.render(table, process.width()));
            process.write("\n");
        }
    }

    private List<Long> convertArrayToList(long[] longs) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long aLong : longs) {
            list.add(aLong);
        }
        return list;
    }

    private List<Integer> convertArrayToList(int[] ints) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int anInt : ints) {
            list.add(anInt);
        }
        return list;
    }

    private void drawMBeanMetadata(CommandProcess process, Map<String, MBeanInfo> mbeanMetadata) {
        TableElement table = MBeanView.createTable();
        for (Map.Entry<String, MBeanInfo> entry : mbeanMetadata.entrySet()) {
            String objectName = entry.getKey();
            MBeanInfo mBeanInfo = entry.getValue();
            this.drawMetaInfo(mBeanInfo, objectName, table);
            this.drawAttributeInfo(mBeanInfo.getAttributes(), table);
            this.drawOperationInfo(mBeanInfo.getOperations(), table);
            this.drawNotificationInfo(mBeanInfo.getNotifications(), table);
        }
        process.write(RenderUtil.render(table, process.width()));
    }

    private void drawMBeanNames(CommandProcess process, List<String> mbeanNames) {
        for (String mbeanName : mbeanNames) {
            process.write(mbeanName).write("\n");
        }
    }

    private static TableElement createTable() {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, Element.label("NAME").style(Decoration.bold.bold()), Element.label("VALUE").style(Decoration.bold.bold()));
        return table;
    }

    private void drawMetaInfo(MBeanInfo mBeanInfo, String objectName, TableElement table) {
        table.row(new LabelElement("MBeanInfo").style(Decoration.bold.fg(Color.red)));
        table.row(new LabelElement("Info:").style(Decoration.bold.fg(Color.yellow)));
        table.row("ObjectName", objectName);
        table.row("ClassName", mBeanInfo.getClassName());
        table.row("Description", mBeanInfo.getDescription());
        this.drawDescriptorInfo("Info Descriptor:", mBeanInfo, table);
        MBeanConstructorInfo[] constructors = mBeanInfo.getConstructors();
        if (constructors.length > 0) {
            for (int i = 0; i < constructors.length; ++i) {
                table.row(new LabelElement("Constructor-" + i).style(Decoration.bold.fg(Color.yellow)));
                table.row("Name", constructors[i].getName());
                table.row("Description", constructors[i].getDescription());
            }
        }
    }

    private void drawAttributeInfo(MBeanAttributeInfo[] attributes, TableElement table) {
        for (MBeanAttributeInfo attribute : attributes) {
            table.row(new LabelElement("MBeanAttributeInfo").style(Decoration.bold.fg(Color.red)));
            table.row(new LabelElement("Attribute:").style(Decoration.bold.fg(Color.yellow)));
            table.row("Name", attribute.getName());
            table.row("Description", attribute.getDescription());
            table.row("Readable", String.valueOf(attribute.isReadable()));
            table.row("Writable", String.valueOf(attribute.isWritable()));
            table.row("Is", String.valueOf(attribute.isIs()));
            table.row("Type", attribute.getType());
            this.drawDescriptorInfo("Attribute Descriptor:", attribute, table);
        }
    }

    private void drawOperationInfo(MBeanOperationInfo[] operations, TableElement table) {
        for (MBeanOperationInfo operation : operations) {
            table.row(new LabelElement("MBeanOperationInfo").style(Decoration.bold.fg(Color.red)));
            table.row(new LabelElement("Operation:").style(Decoration.bold.fg(Color.yellow)));
            table.row("Name", operation.getName());
            table.row("Description", operation.getDescription());
            String impact = "";
            switch (operation.getImpact()) {
                case 1: {
                    impact = "action";
                    break;
                }
                case 2: {
                    impact = "action/info";
                    break;
                }
                case 0: {
                    impact = "info";
                    break;
                }
                case 3: {
                    impact = "unknown";
                }
            }
            table.row("Impact", impact);
            table.row("ReturnType", operation.getReturnType());
            MBeanParameterInfo[] signature = operation.getSignature();
            if (signature.length > 0) {
                for (int i = 0; i < signature.length; ++i) {
                    table.row(new LabelElement("Parameter-" + i).style(Decoration.bold.fg(Color.yellow)));
                    table.row("Name", signature[i].getName());
                    table.row("Type", signature[i].getType());
                    table.row("Description", signature[i].getDescription());
                }
            }
            this.drawDescriptorInfo("Operation Descriptor:", operation, table);
        }
    }

    private void drawNotificationInfo(MBeanNotificationInfo[] notificationInfos, TableElement table) {
        for (MBeanNotificationInfo notificationInfo : notificationInfos) {
            table.row(new LabelElement("MBeanNotificationInfo").style(Decoration.bold.fg(Color.red)));
            table.row(new LabelElement("Notification:").style(Decoration.bold.fg(Color.yellow)));
            table.row("Name", notificationInfo.getName());
            table.row("Description", notificationInfo.getDescription());
            table.row("NotifTypes", Arrays.toString(notificationInfo.getNotifTypes()));
            this.drawDescriptorInfo("Notification Descriptor:", notificationInfo, table);
        }
    }

    private void drawDescriptorInfo(String title, DescriptorRead descriptorRead, TableElement table) {
        Descriptor descriptor = descriptorRead.getDescriptor();
        String[] fieldNames = descriptor.getFieldNames();
        if (fieldNames.length > 0) {
            table.row(new LabelElement(title).style(Decoration.bold.fg(Color.yellow)));
            for (String fieldName : fieldNames) {
                Object fieldValue = descriptor.getFieldValue(fieldName);
                table.row(fieldName, fieldValue == null ? "" : fieldValue.toString());
            }
        }
    }
}

