package com.ruoyi.web.controller.screen;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyEconomyInfo;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.ext.GridCompanyEconomyPermuItem;
import com.ruoyi.system.domain.grid.vo.GridEconomyPerMuItem;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.service.grid.*;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * * Author: brenda
 * * 2024/12/17
 **/
@Api(tags = "大屏接口-经济运行")
@RestController
@RequestMapping("/api/grid/screen/economy")
public class ScreenEconomyController {

    @Autowired
    private GridRegionMapper gridRegionMapper;

    @Autowired
    private GridCompanyEconomyInfoService gridCompanyEconomyInfoService;

    @Autowired
    private GridCompanyLandService gridCompanyLandService;

    @Autowired
    private GridCompanyLandRemarkService gridCompanyLandRemarkService;

    @Autowired
    private GridRegionFacadeService gridRegionFacadeService;

    /**
     * 经济地块点位
     * @return
     */
    @RequestMapping(value = "/pointList", method = RequestMethod.GET)
    @ResponseBody
    public AjaxResult getEconomyPointList(@RequestParam("perMuRangeStart") String perMuRangeStart,
                                          @RequestParam("perMuRangeEnd") String perMuRangeEnd,
                                          @RequestParam("year") String year) {
        return AjaxResult.success(gridRegionFacadeService.getEconomyPointList(perMuRangeStart, perMuRangeEnd, year));

    }

    /**
     * 大屏：企业经济信息统计
     */
    @GetMapping(value = "/info/list")
    public AjaxResult ecoInfoList(@RequestParam(value = "type") String type,
                                    @RequestParam(value = "year", required = false) String year,
                                    @RequestParam(value = "searchName", required = false) String searchName) {
        if (StringUtils.isBlank(type)) {
            return AjaxResult.error(400, "缺少必要参数");
        }
        if (StringUtils.isBlank(year)) {
            LocalDate localDate = LocalDate.now();
            year = String.valueOf(localDate.getYear());
        }
        return AjaxResult.success(gridCompanyEconomyInfoService.loadCompanyEcoInfos(type, year, searchName));
    }

    /**
     * 亩均经济比例统计
     */
    @GetMapping(value = "/perMu/count")
    public AjaxResult perMuCount(@RequestParam(value = "year", required = false) String year) {
        if (StringUtils.isBlank(year)) {
            LocalDate localDate = LocalDate.now();
            year = String.valueOf(localDate.getYear());
        }
        List<GridCompanyEconomyPermuItem> list = gridCompanyEconomyInfoService.listPerMuByYear(year);
        GridCompanyEconomyPermuItem totalBean = new GridCompanyEconomyPermuItem();
        totalBean.setCountCode("total");
        totalBean.setCountName("总数");
        totalBean.setNum(list.stream().mapToInt(GridCompanyEconomyPermuItem::getNum).sum());
        list.add(totalBean);
        return AjaxResult.success(list);
    }

    /**
     * 地块亩均税收排名
     */
    @GetMapping(value = "/permuSort/list")
    public AjaxResult permuSortList(@RequestParam(value = "year", required = false) String year) {
        LocalDate nowDate = LocalDate.now();
        String lastYear = "";
        if(StringUtils.isBlank(year)){
            year = String.valueOf(nowDate.getYear());
            lastYear = String.valueOf(nowDate.minusYears(1).getYear());
        }else{
            lastYear = String.valueOf((Integer.parseInt(year) - 1));
        }
        List<GridEconomyPerMuItem> currentList = gridCompanyLandService.permuSortList(year);
        List<GridEconomyPerMuItem> lastList = gridCompanyLandService.permuSortList(lastYear);
        if(!CollectionUtils.isEmpty(currentList)){
            Map<String, GridEconomyPerMuItem> lastYearMap = new LinkedHashMap<>();
            if(!CollectionUtils.isEmpty(lastList)){
                lastYearMap = lastList.stream().collect(Collectors.toMap(GridEconomyPerMuItem::getId, Function.identity()));
            }
            for(GridEconomyPerMuItem item : currentList){
                if(!lastYearMap.isEmpty() && lastYearMap.containsKey(item.getId())){
                    GridEconomyPerMuItem lastItem = lastYearMap.get(item.getId());
                    BigDecimal currentPerMu = BigDecimal.valueOf(item.getPerMuSum());
                    BigDecimal lastPerMu = BigDecimal.valueOf(lastItem.getPerMuSum());
                    if(lastPerMu.compareTo(BigDecimal.ZERO) == 0){
                        item.setPercent("100%");
                    }else{
                        BigDecimal cha = currentPerMu.subtract(lastPerMu);
                        if(cha.compareTo(new BigDecimal(0)) < 0){
                            item.setUpFlag(false);
                        }
                        BigDecimal percent = cha.abs().divide(lastPerMu, 2, RoundingMode.HALF_UP);
                        item.setPercent(percent +"%");
                    }
                }
            }
        }
        return AjaxResult.success(currentList);
    }

}
