package com.ruoyi.system.service.grid.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.bean.BeanCopyUtil;
import com.ruoyi.common.zqt.ZQTImportExcelUtil;
import com.ruoyi.common.zqt.ZQTPageUtil;
import com.ruoyi.system.domain.grid.*;
import com.ruoyi.system.domain.grid.ext.GridHouseExt;
import com.ruoyi.system.domain.grid.ext.GridHousePeopleExt;
import com.ruoyi.system.domain.grid.vo.GridHouseSearchParam;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.visit.enums.VisitTypeEnum;
import com.ruoyi.system.domain.visit.ext.VisitFreeInterviewExt;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridHouseMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.*;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.system.ISysUserService;
import com.ruoyi.system.service.visit.VisitFreeInterviewService;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridHouseService实现
 */
@Service
@MyBaseService
public class GridHouseServiceImpl extends BaseServiceImpl<GridHouseMapper, GridHouse, GridHouseExample> implements GridHouseService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridHouseServiceImpl.class);

    @Autowired
    GridHouseMapper gridHouseMapper;
    @Autowired
    BsCommonService bsCommonService;
    @Autowired
    GridRegionService gridRegionService;
    @Autowired
    GridHousePeopleService gridHousePeopleService;
    @Autowired
    private GridPeopleService gridPeopleService;
    @Autowired
    private GridWgLogService gridWgLogService;
    @Autowired
    private GridRegionUserService gridRegionUserService;
    @Autowired
    private VisitFreeInterviewService visitFreeInterviewService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public PageInfo page(GridHouseSearchParam wsHouse, String value) {
        List<GridHouseExt> houseExtList = gridHouseMapper.pageHouse(wsHouse, value);
        PageInfo<GridHouseExt> pageInfo = new PageInfo<>(houseExtList);
        if(!CollectionUtils.isEmpty(pageInfo.getList())){
            Map<String, String> regionMap = gridRegionService.getMapByWgCodes(pageInfo.getList().stream().map(GridHouse::getWgCode).collect(Collectors.toList()));
            Map<String, String> fwlxMap = bsCommonService.getMapByCodes(pageInfo.getList().stream().map(GridHouse::getFwlxCode).collect(Collectors.toList()));
            Map<String, String> fwztMap = bsCommonService.getMapByCodes(pageInfo.getList().stream().map(GridHouse::getFwztCode).collect(Collectors.toList()));
            for(GridHouseExt ext : pageInfo.getList()){
                if(StringUtils.isNotBlank(fwlxMap.get(ext.getFwlxCode()))){
                    ext.setFwlxValue(fwlxMap.get(ext.getFwlxCode()));
                }
                if(StringUtils.isNotBlank(fwztMap.get(ext.getFwztCode()))){
                    ext.setFwztValue(fwztMap.get(ext.getFwztCode()));
                }
                if (StringUtils.isNotBlank(ext.getWgCode())) {
                    ext.setWgValue(regionMap.get(ext.getWgCode()));
                    GridRegion wg = gridRegionService.getWgOtherCode(ext.getWgCode());
                    if (wg != null) {
                        ext.setWgOtherCode(wg.getWgCode());
                        ext.setWgOtherCodeValue(wg.getWgName());
                    }
                }
                // 查询住户
                List<GridHousePeople> housePeopleList = gridHousePeopleService.selectGridHousePeopleByHouseId(ext.getId(), null);
                if(!CollectionUtils.isEmpty(housePeopleList)){
                    GridPeopleExample peopleExample = new GridPeopleExample();
                    GridPeopleExample.Criteria criteria = peopleExample.createCriteria();
                    criteria.andIdIn(housePeopleList.stream().map(GridHousePeople::getPeopleId).collect(Collectors.toList()));
                    List<GridPeople> peopleList = gridPeopleService.selectByExample(peopleExample);
                    if(!CollectionUtils.isEmpty(peopleList)){
                        ext.setCommonPeople(peopleList.stream().map(GridPeople::getPersonName).collect(Collectors.joining(",")));
                    }
                }
            }
        }
        return pageInfo;
    }

    @Override
    @Transactional
    public AjaxResult add(GridHouse wsHouse) {
        wsHouse.setId(IdUtil.fastSimpleUUID());
        wsHouse.setCreateTime(DateUtil.formatDateTime(new Date()));
        this.insertSelective(wsHouse);

        // 日志
        GridWgLog wsWgLog = new GridWgLog();
        wsWgLog.setCreateId(wsHouse.getCreateId());
        SysUser sysUser = sysUserService.selectUserById(wsHouse.getCreateId());
        wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
        wsWgLog.setCreateWgCode(wsHouse.getWgCode());
        wsWgLog.setObjectName(wsHouse.getHouseName());
        wsWgLog.setType("2");
        wsWgLog.setOperate("insert");
        wsWgLog.setObjectId(wsHouse.getId());
        gridWgLogService.add(wsWgLog);

        return AjaxResult.success(wsHouse.getId());
    }

    @Override
    @Transactional
    public AjaxResult edit(GridHouse wsHouse) {
        Validator.validateNotEmpty(wsHouse.getId(), "id is empty");
        wsHouse.setUpdateTime(DateUtil.formatDateTime(new Date()));

        // 对比字段
        List<String> contentList = new ArrayList<>();
        GridHouse origin = this.selectByPrimaryKey(wsHouse.getId());

        if ((StringUtils.isNotBlank(origin.getWgCode()) && !origin.getWgCode().equals(wsHouse.getWgCode()))
                || (StringUtils.isBlank(origin.getWgCode()) && StringUtils.isNotBlank(wsHouse.getWgCode()))) {
            contentList.add("所属村社区");
        }

        if ((StringUtils.isNotBlank(origin.getFwlxCode()) && !origin.getFwlxCode().equals(wsHouse.getFwlxCode()))
                || (StringUtils.isBlank(origin.getFwlxCode()) && StringUtils.isNotBlank(wsHouse.getFwlxCode()))) {
            contentList.add("房屋类型");
        }

        if ((StringUtils.isNotBlank(origin.getHouseName()) && !origin.getHouseName().equals(wsHouse.getHouseName()))
                || (StringUtils.isBlank(origin.getHouseName()) && StringUtils.isNotBlank(wsHouse.getHouseName()))) {
            contentList.add("房屋名称");
        }

        if ((StringUtils.isNotBlank(origin.getFwztCode()) && !origin.getFwztCode().equals(wsHouse.getFwztCode()))
                || (StringUtils.isBlank(origin.getFwztCode()) && StringUtils.isNotBlank(wsHouse.getFwztCode()))) {
            contentList.add("房屋状态");
        }

        if ((StringUtils.isNotBlank(origin.getPersonIdCard()) && !origin.getPersonIdCard().equals(wsHouse.getPersonIdCard()))
                || (StringUtils.isBlank(origin.getPersonIdCard()) && StringUtils.isNotBlank(wsHouse.getPersonIdCard()))) {
            contentList.add("业主身份证号码");
        }

        if ((StringUtils.isNotBlank(origin.getPersonName()) && !origin.getPersonName().equals(wsHouse.getPersonName()))
                || (StringUtils.isBlank(origin.getPersonName()) && StringUtils.isNotBlank(wsHouse.getPersonName()))) {
            contentList.add("业主姓名");
        }

        if ((StringUtils.isNotBlank(origin.getPersonPhone()) && !origin.getPersonPhone().equals(wsHouse.getPersonPhone()))
                || (StringUtils.isBlank(origin.getPersonPhone()) && StringUtils.isNotBlank(wsHouse.getPersonPhone()))) {
            contentList.add("业主手机号码");
        }

        if ((StringUtils.isNotBlank(origin.getHouseAddress()) && !origin.getHouseAddress().equals(wsHouse.getHouseAddress()))
                || (StringUtils.isBlank(origin.getHouseAddress()) && StringUtils.isNotBlank(wsHouse.getHouseAddress()))) {
            contentList.add("位置");
        }

        if ((StringUtils.isNotBlank(origin.getLongitude()) && !origin.getLongitude().equals(wsHouse.getLongitude()))
                || (StringUtils.isBlank(origin.getLongitude()) && StringUtils.isNotBlank(wsHouse.getLongitude()))) {
            contentList.add("房屋定位地址");
        } else if ((StringUtils.isNotBlank(origin.getLatitude()) && !origin.getLatitude().equals(wsHouse.getLatitude()))
                || (StringUtils.isBlank(origin.getLatitude()) && StringUtils.isNotBlank(wsHouse.getLatitude()))) {
            contentList.add("房屋定位地址");
        }

        this.updateByPrimaryKeySelective(wsHouse);

        //更新走访
        if(!CollectionUtils.isEmpty(contentList)){
            SysUser sysUser = sysUserService.selectUserById(wsHouse.getUpdateId());
            VisitFreeInterviewExt visitFreeInterviewExt = new VisitFreeInterviewExt();
            visitFreeInterviewExt.setWgCode(wsHouse.getWgCode());
            visitFreeInterviewExt.setWgValue(gridRegionService.getWgName(wsHouse.getWgCode()));
            GridRegionUser gridRegionUser = gridRegionUserService.selectByUserId(sysUser.getUserId());
            visitFreeInterviewExt.setWgyCode(gridRegionUser == null?"":gridRegionUser.getWgId());
            visitFreeInterviewExt.setWgyName(sysUser != null ? sysUser.getNickName() : "");
            visitFreeInterviewExt.setInterviewTime(DateUtil.formatDateTime(new Date()));
            visitFreeInterviewExt.setType("3");
            visitFreeInterviewExt.setContent("完成房屋基本信息更新，更新字段："+ StringUtils.join(contentList, ","));
            visitFreeInterviewExt.setObjId(wsHouse.getId());
            visitFreeInterviewExt.setAddress(wsHouse.getHouseAddress());
            visitFreeInterviewExt.setInterviewTime(DateUtil.formatDate(new Date()));
            visitFreeInterviewExt.setActualTime(DateUtil.formatDateTime(new Date()));
            visitFreeInterviewExt.setObjName(wsHouse.getHouseName());
            visitFreeInterviewExt.setObjType(wsHouse.getFwlxCode());
            String objectName = bsCommonService.getName(wsHouse.getFwlxCode());
            visitFreeInterviewExt.setObjTypeName(objectName);
            visitFreeInterviewExt.setObjUserName(wsHouse.getPersonName());
            visitFreeInterviewExt.setObjNumber(wsHouse.getHouseName());
            visitFreeInterviewExt.setLongitude(wsHouse.getLongitude());
            visitFreeInterviewExt.setLatitude(wsHouse.getLatitude());
            visitFreeInterviewExt.setVisitType(VisitTypeEnum.UPDATE_VISIT.getCode());
            visitFreeInterviewService.addVisitFreeInterview(visitFreeInterviewExt);

            // 日志
            GridWgLog wsWgLog = new GridWgLog();
            wsWgLog.setCreateId(wsHouse.getUpdateId());
            wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
            wsWgLog.setCreateWgCode(wsHouse.getWgCode());
            wsWgLog.setObjectName(wsHouse.getHouseName());
            wsWgLog.setType("2");
            wsWgLog.setOperate("update");
            wsWgLog.setContent(StringUtils.join(contentList, ","));
            wsWgLog.setObjectId(wsHouse.getId());
            gridWgLogService.add(wsWgLog);
        }

        return AjaxResult.success(null);
    }

    @Override
    public AjaxResult detail(String id) {
        GridHouse wsHouse = this.selectByPrimaryKey(id);
        GridHouseExt wsHouseExt = BeanCopyUtil.toBean(wsHouse, GridHouseExt.class);
        if (wsHouseExt != null) {
            if (Byte.valueOf("1").equals(wsHouseExt.getIsValid())) {
                this.selectGridHouseExt(wsHouseExt);
            } else {
                return AjaxResult.success(null);
            }
        }
        return AjaxResult.success(wsHouseExt);
    }

    @Override
    public AjaxResult delete(String id) {
        // 是否存在关联人口
        GridHousePeopleExample ex = new GridHousePeopleExample();
        GridHousePeopleExample.Criteria ca = ex.createCriteria();
        ca.andHouseIdEqualTo(id);
        int a = gridHousePeopleService.countByExample(ex);
        if (a > 0) {
            return AjaxResult.error(400, "住宅已存在人员绑定关系，不可删除，如需删除此住宅，请先解绑对应关系");
        }
        // 删除住宅
        GridHouse wsHouse = this.selectByPrimaryKey(id);
        wsHouse.setIsValid(Byte.valueOf("0"));
        this.updateByPrimaryKeySelective(wsHouse);
        return AjaxResult.success(null);
    }

    @Override
    public PageInfo houseToPeoplePage(String houseId) {
        List<GridHousePeople> housePeopleList = gridHousePeopleService.selectGridHousePeopleByHouseId(houseId, null);
        List<GridHousePeopleExt> housePeopleExtList = BeanCopyUtil.bathToBean(housePeopleList, GridHousePeopleExt.class);
        Map<String, String> regionMap = gridRegionService.getGridRegionMap().stream().collect(Collectors.toMap(GridRegion::getWgCode, GridRegion::getWgName));
        Map<String, String> commonMap = bsCommonService.getBsCommonMap().stream().collect(Collectors.toMap(BsCommon::getCode, BsCommon::getName));
        for (GridHousePeopleExt h : housePeopleExtList) {
            gridHousePeopleService.selectGridHousePeopleExt(regionMap, commonMap, h, false, true);
        }
        PageInfo<GridHousePeopleExt> pageInfo = ZQTPageUtil.build(housePeopleList, housePeopleExtList);
        return pageInfo;
    }

    @Override
    @Transactional
    public AjaxResult houseBindPeople(GridHousePeople wsHousePeople) {
        List<GridHousePeople> housePeopleList = gridHousePeopleService.selectGridHousePeopleByHouseId(wsHousePeople.getHouseId(), wsHousePeople.getPeopleId());
        if (housePeopleList.size() > 0) {
            return AjaxResult.error(400, "该人员已绑定该住宅");
        }
        wsHousePeople.setId(IdUtil.fastSimpleUUID());
        wsHousePeople.setCreateTime(DateUtil.formatDateTime(new Date()));
        gridHousePeopleService.insertSelective(wsHousePeople);

        SysUser sysUser = sysUserService.selectUserById(wsHousePeople.getCreateId());
        GridPeople gridPeople = gridPeopleService.selectByPrimaryKey(wsHousePeople.getPeopleId());
        // 日志
        GridWgLog wsWgLog = new GridWgLog();
        wsWgLog.setCreateId(wsHousePeople.getCreateId());
        wsWgLog.setCreateName(sysUser != null ? sysUser.getNickName() : "");
        wsWgLog.setCreateWgCode(gridPeople.getWgCode());
        wsWgLog.setObjectName(this.selectByPrimaryKey(wsHousePeople.getHouseId()).getHouseName());
        wsWgLog.setBindName(gridPeople.getPersonName());
        wsWgLog.setType("2");
        wsWgLog.setOperate("bind");
        wsWgLog.setObjectId(wsHousePeople.getId());
        gridWgLogService.add(wsWgLog);

        return AjaxResult.success(null);
    }

    @Override
    public GridHouseExt selectGridHouseExt(GridHouseExt wsHouseExt) {

        Map<String, String> regionMap = gridRegionService.getGridRegionMap().stream().collect(Collectors.toMap(GridRegion::getWgCode, GridRegion::getWgName));
        Map<String, String> commonMap = bsCommonService.getBsCommonMap().stream().collect(Collectors.toMap(BsCommon::getCode, BsCommon::getName));

        this.dealGridHouseExt(regionMap, commonMap, wsHouseExt);

        return wsHouseExt;
    }

    @Override
    public GridHouseExt dealGridHouseExt(Map<String, String> regionMap, Map<String, String> commonMap, GridHouseExt wsHouseExt) {
        if (StringUtils.isNotBlank(wsHouseExt.getWgCode())) {
            wsHouseExt.setWgValue(regionMap.get(wsHouseExt.getWgCode()));
            GridRegion wg = gridRegionService.getWgOtherCode(wsHouseExt.getWgCode());
            if (wg != null) {
                wsHouseExt.setWgOtherCode(wg.getWgCode());
                wsHouseExt.setWgOtherCodeValue(wg.getWgName());
            }
        }

        if (StringUtils.isNotBlank(wsHouseExt.getFwlxCode())) {
            wsHouseExt.setFwlxValue(commonMap.get(wsHouseExt.getFwlxCode()));
        }

        if (StringUtils.isNotBlank(wsHouseExt.getFwztCode())) {
            wsHouseExt.setFwztValue(commonMap.get(wsHouseExt.getFwztCode()));
        }

//        wsHouseExt.setPersonIdCard(DesensitizedUtil.idCardNum(wsHouseExt.getPersonIdCard(), 6, 4));
//        wsHouseExt.setPersonPhone(DesensitizedUtil.mobilePhone(wsHouseExt.getPersonPhone()));

        return wsHouseExt;
    }

    @Override
    public List<Map<String, Object>> countGridHouse(String wgCode) {
        List<String> wgCodes = new ArrayList<>();
        if(StringUtils.isNotBlank(wgCode)){
            wgCodes = Arrays.asList(wgCode.split(","));
        }
        return gridHouseMapper.countGridHouse(wgCodes);
    }

    @Override
    public List<Map<String, Object>> countGridHouseByFwzt(String wgCode) {
        List<String> wgCodes = new ArrayList<>();
        if(StringUtils.isNotBlank(wgCode)){
            wgCodes = Arrays.asList(wgCode.split(","));
        }
        return gridHouseMapper.countGridHouseByFwzt(wgCodes);
    }

    @Override
    public int countAll(String wgCode) {
        GridHouseSearchParam param = new GridHouseSearchParam();
        if(StringUtils.isNotBlank(wgCode)){
            param.setWgCodeLikes(Arrays.asList(wgCode.split(",")));
        }
        return gridHouseMapper.countByParam(param);
    }

    @Override
    public List<Map<String, Object>> countGridHouseByGrid() {
        return gridHouseMapper.countGridHouseByGrid();
    }

    @Override
    public List<GridHouse> selectGridHouseByHouseName(String houseName, String personIdCard) {
        GridHouseExample ex = new GridHouseExample();
        GridHouseExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo(Byte.valueOf("1"));
        if (StringUtils.isNotBlank(houseName)) {
            ca.andHouseNameEqualTo(houseName);
        }
        if (StringUtils.isNotBlank(personIdCard)) {
            ca.andPersonIdCardEqualTo(personIdCard);
        }
        return this.selectByExample(ex);
    }

    @Override
    public AjaxResult importExcel(MultipartFile file, String createId) {
        if (file == null) {
            return AjaxResult.error(400, "文件不存在");
        }
        StringBuilder msg = new StringBuilder();
        Workbook workbook = null;
        try {
            String fileName = file.getOriginalFilename();
            InputStream is = file.getInputStream();
            if ("xls".equals(ZQTImportExcelUtil.getPostFix(fileName))) {
                workbook = new HSSFWorkbook(is);
            } else if ("xlsx".equals(ZQTImportExcelUtil.getPostFix(fileName))) {
                workbook = new XSSFWorkbook(is);
            } else {
                return AjaxResult.error(400, "文件格式不正确");
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            msg.append(e.getMessage());
        } catch (IOException e) {
            e.printStackTrace();
            msg.append(e.getMessage());
            return AjaxResult.error(400, "系统错误" + msg);
        }

        Map<String, String> regionMap = gridRegionService.getGridRegionMap().stream().collect(Collectors.toMap(GridRegion::getWgName, GridRegion::getWgCode));
        Map<String, String> commonMap = bsCommonService.getBsCommonMap().stream().collect(Collectors.toMap(BsCommon::getName, BsCommon::getCode));
        List<GridHouse> list = new ArrayList<>();

//        for (int i = 0; i < workbook.getNumberOfSheets(); i++) {
//            Sheet sheet = workbook.getSheetAt(i); //读取工作表
//            if (sheet == null) //空判断
//                continue;
//            for (int j = 1; j <= sheet.getLastRowNum(); j++) {
//                Row row = sheet.getRow(j); //读取每行
//                if (row.getCell(0) != null) {
//                    GridHouse ce = new GridHouse();
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(0)))) {
//                        msg.append("第").append(j).append("行所属地块不能为空;");
//                    } else {
//                        String value = ImportExcelUtil.getValue(row.getCell(0)).trim();
//                        if (!regionMap.containsKey(value)) {
//                            msg.append("第").append(j).append("行未找到对应所属地块;");
//                        } else {
//                            ce.setWgCode(regionMap.get(value));
//                        }
//                    }
//
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(1)))) {
//                        msg.append("第").append(j).append("行房屋类型不能为空;");
//                    } else {
//                        String value = ImportExcelUtil.getValue(row.getCell(1)).trim();
//                        if (!commonMap.containsKey(value)) {
//                            msg.append("第").append(j).append("行未找到对应房屋类型;");
//                        } else {
//                            ce.setFwlxCode(commonMap.get(value));
//                        }
//                    }
//
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(2)))) {
//                        msg.append("第").append(j).append("行房屋号不能为空;");
//                    } else {
//                        ce.setHouseName(ImportExcelUtil.getValue(row.getCell(2)).trim());
//                    }
//
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(3)))) {
//                        msg.append("第").append(j).append("行房屋状态不能为空;");
//                    } else {
//                        String value = ImportExcelUtil.getValue(row.getCell(3)).trim();
//                        if (!commonMap.containsKey(value)) {
//                            msg.append("第").append(j).append("行未找到对应房屋状态;");
//                        } else {
//                            ce.setFwztCode(commonMap.get(value));
//                        }
//                    }
//
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(4)))) {
//                        ce.setPersonIdCard(null);
//                    } else {
//                        String ID_18 = ImportExcelUtil.getValue(row.getCell(4)).trim();
//                        boolean valid = IdcardUtil.isValidCard(ID_18);
//                        if (!valid) {
//                            msg.append("第").append(j).append("行身份证号码不合法;");
//                        } else {
//                            ce.setPersonIdCard(ID_18);
//                        }
//                    }
//
//                    ce.setPersonName(ImportExcelUtil.getValue(row.getCell(5)));
//
//                    if (StringUtils.isBlank(ImportExcelUtil.getValue(row.getCell(6)))) {
//                        ce.setPersonPhone(null);
//                    } else {
//                        String phone = ImportExcelUtil.getValue(row.getCell(6)).trim();
//                        if (!Pattern.matches("^(13[0-9]|14[01456879]|15[0-35-9]|16[2567]|17[0-8]|18[0-9]|19[0-35-9])\\d{8}$", phone)) {
//                            msg.append("第").append(j).append("行手机号码不合法;");
//                        } else {
//                            ce.setPersonPhone(phone);
//                        }
//                    }
//                    ce.setHouseAddress(ImportExcelUtil.getValue(row.getCell(7)));
//                    list.add(ce);
//                }
//            }
//        }


        for (int i = 0; i < workbook.getNumberOfSheets(); i++) {
            Sheet sheet = workbook.getSheetAt(i); //读取工作表
            if (sheet == null) //空判断
                continue;
            for (int j = 1; j <= sheet.getLastRowNum(); j++) {
                Row row = sheet.getRow(j); //读取每行
                if (row.getCell(0) != null) {
                    GridHouse ce = new GridHouse();
                    ce.setWgCode(regionMap.get(ZQTImportExcelUtil.getValue(row.getCell(0))));
                    ce.setFwlxCode(commonMap.get(ZQTImportExcelUtil.getValue(row.getCell(1))));
                    ce.setHouseName(ZQTImportExcelUtil.getValue(row.getCell(2)));
                    ce.setFwztCode(commonMap.get(ZQTImportExcelUtil.getValue(row.getCell(3))));
                    ce.setPersonIdCard(ZQTImportExcelUtil.getValue(row.getCell(4)));
                    ce.setPersonName(ZQTImportExcelUtil.getValue(row.getCell(5)));
                    ce.setPersonPhone(ZQTImportExcelUtil.getValue(row.getCell(6)));
                    ce.setHouseAddress(ZQTImportExcelUtil.getValue(row.getCell(7)));
                    list.add(ce);
                }
            }
        }

        if (StringUtils.isBlank(msg)) {
            int records = 0;
            int temp = 0;
            try {
                for (GridHouse ce : list) {
                    List<GridHouse> houseList = this.selectGridHouseByHouseName(ce.getHouseName(), ce.getPersonIdCard());
                    if (houseList.isEmpty()) {
                        ce.setId(IdUtil.fastSimpleUUID());
                        ce.setCreateId(createId);
                        ce.setCreateTime(DateUtil.formatDateTime(new Date()));
                        temp = this.insertSelective(ce);
                    } else {
                        ce.setId(houseList.get(0).getId());
                        ce.setUpdateId(createId);
                        ce.setUpdateTime(DateUtil.formatDateTime(new Date()));
                        temp = this.updateByPrimaryKeySelective(ce);
                    }
                    if (temp == 1) {
                        records++;
                    } else {
                        msg.append("第").append(records + 2).append("行数据导入出错:");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
                msg.append(e.getMessage());
                return AjaxResult.error(400, msg.toString());
            }
            msg.append("导入").append(records).append("条数据");
            return AjaxResult.success("success", msg.toString());//返回成功信息
        }
        return AjaxResult.error(400, msg.toString());
    }

    @Override
    public List<GridHouse> getAllHouseList() {
        GridHouseExample example = new GridHouseExample();
        GridHouseExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo(Byte.valueOf("1"));
        return gridHouseMapper.selectByExample(example);
    }
}
