package com.ruoyi.system.service.house.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.HouseResourceAssociationObject;
import com.ruoyi.system.domain.house.enums.HouseEnums;
import com.ruoyi.system.domain.house.vo.HouseResourcePage;
import com.ruoyi.system.domain.house.vo.HouseResourcePageQuery;
import com.ruoyi.system.domain.house.vo.HouseResourceSaveUpdateDto;
import com.ruoyi.system.mapper.house.HouseResourceAssociationObjectMapper;
import com.ruoyi.system.mapper.house.HouseResourceMapper;
import com.ruoyi.system.service.house.HouseResourceService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
public class HouseResourceServiceImpl implements HouseResourceService {

    private final HouseResourceMapper houseResourceMapper;

    private final HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper;

    public HouseResourceServiceImpl(HouseResourceMapper houseResourceMapper, HouseResourceAssociationObjectMapper houseResourceAssociationObjectMapper) {
        this.houseResourceMapper = houseResourceMapper;
        this.houseResourceAssociationObjectMapper = houseResourceAssociationObjectMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveHouseResource(HouseResourceSaveUpdateDto dto) {
        String houseResourceId = UUID.randomUUID().toString().replaceAll("-", "");
        dto.getHouseResource().setId(houseResourceId);
        houseResourceMapper.insertHouseResource(dto.getHouseResource());

        dto.getHouseResourceAssociationObjects().forEach(x -> {
            x.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            x.setHouseResourceId(houseResourceId);
            houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(x);
        });
    }

    @Override
    public HouseResource queryHouseResourceById(String id) {
        return houseResourceMapper.selectHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateHouseResource(HouseResourceSaveUpdateDto dto) {
        if (Objects.isNull(dto.getHouseResource().getId())) {
            throw new RuntimeException("房源id不能为空");
        }
        houseResourceMapper.updateHouseResource(dto.getHouseResource());
        dto.getHouseResourceAssociationObjects().forEach(x -> {
            if (Objects.isNull(x.getId())) {
                x.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                x.setHouseResourceId(dto.getHouseResource().getId());
                houseResourceAssociationObjectMapper.insertHouseResourceObjectAssociation(x);
            } else {
                HouseResourceAssociationObject houseResourceAssociationObject = houseResourceAssociationObjectMapper.selectHouseResourceObjectAssociationById(x.getId());
                houseResourceAssociationObject.setOperateType(2);
                houseResourceAssociationObject.setRelieveTime(new Date());
                houseResourceAssociationObjectMapper.updateHouseResourceObjectAssociation(houseResourceAssociationObject);
            }
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteHouseResourceById(String id) {
        houseResourceMapper.deleteHouseResourceById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchSaveHouseResources(List<HouseResource> houseResources) {
        houseResourceMapper.batchInsertHouseResources(houseResources);
    }

    @Override
    public IPage<HouseResourcePage> pageHouseResources(HouseResourcePageQuery query) {
        IPage<HouseResourcePage> page = houseResourceMapper.selectPage(new Page<>(query.getPageNum(), query.getPageSize()), query);
        page.getRecords().forEach(x -> {
            x.setHouseResourceUrlList(Arrays.asList(x.getHouseResourceUrl().split(",")));
            x.setHouseResourceAttributeText(HouseEnums.HouseResourceAttributeEnum.getDescByCode(x.getHouseResourceAttribute()));
            x.setHouseResourceTypeText(HouseEnums.HouseResourceTypeEnum.getDescByCode(x.getHouseResourceType()));
            x.setOrientationText(HouseEnums.OrientationEnum.getDescByCode(x.getOrientation()));
            x.setDecorationConditionText(HouseEnums.DecorationConditionEnum.getDescByCode(x.getDecorationCondition()));
            x.setRentalUnitText(HouseEnums.RentalUnitEnum.getDescByCode(x.getRentalUnit()));
            x.setHireStatusText(HouseEnums.hireStatusTextEnum.getDescByCode(x.getHireStatus()));
        });
        return page;
    }
}
