package com.ruoyi.common.zqt;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Description :
 * @Author : jiangc
 * @Date : 2019/5/29
 */
public class ZQTPageUtil {

    public static PageInfo build(List source, List target) {
        List page = source;//此处的source已经是经过拦截转换后的com.github.pagehelper.Page对象，包含了分页信息
        page.clear();//清空以前的集合数据
        page.addAll(target);//添加扩展bean集合数据
        PageInfo pageInfo = new PageInfo(page);
        return pageInfo;
    }

    public static <T> Page<T> buildPage(List<T> list, int pageNum, int pageSize) {
        Page<T> page = new Page<>(pageNum, pageSize);
        int total = list.size();
        page.setTotal(total);
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, total);
        if (startIndex < endIndex) {
            page.addAll(list.subList(startIndex, endIndex));
        }
        return page;
    }

    public static <T> PageInfo<T> build(PageInfo<T> page, int pageNum, int pageSize, int count) {
        page.setPageNum(pageNum);
        page.setTotal(count);
        page.setPages((int) Math.ceil(1.0 * count / pageSize));
        return page;
    }

    public static <T> PageInfo<T> bulid(List source, List<T> target) {

        List page = source;//此处的source已经是经过拦截转换后的com.github.pagehelper.Page对象，包含了分页信息
        page.clear();//清空以前的集合数据
        page.addAll(target);//添加扩展bean集合数据

        PageInfo<T> pageInfo = new PageInfo<T>(page);

        return pageInfo;
    }


}
