package com.ruoyi.system.service.operatingmanage.impl;

import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.operatingmanage.TOperatingmanageNoticeRange;
import com.ruoyi.system.mapper.operatingmanage.TOperatingmanageNoticeRangeMapper;
import com.ruoyi.system.service.operatingmanage.TOperatingmanageNoticeRangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 通知公告范围
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TOperatingmanageNoticeRangeServiceImpl implements TOperatingmanageNoticeRangeService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TOperatingmanageNoticeRangeMapper tOperatingmanageNoticeRangeMapper;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TOperatingmanageNoticeRange> list(TOperatingmanageNoticeRange tOperatingmanageNoticeRange) {
		return tOperatingmanageNoticeRangeMapper.list(tOperatingmanageNoticeRange);
	}

	/**
	* 查询
	* @param id
	*/
	private TOperatingmanageNoticeRange getObjectById(Long id) {
		Query query = new Query();
		query.put("id",id);
		return tOperatingmanageNoticeRangeMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param tOperatingmanageNoticeRange
     * @return
     */
	@Override
	public List<TOperatingmanageNoticeRange> listTOperatingmanageNoticeRange(TOperatingmanageNoticeRange tOperatingmanageNoticeRange) {
		return this.list(tOperatingmanageNoticeRange);
	}

    /**
     * 新增
     * @param tOperatingmanageNoticeRange
     * @return
     */
	@Override
	public int saveTOperatingmanageNoticeRange(TOperatingmanageNoticeRange tOperatingmanageNoticeRange) {
		return tOperatingmanageNoticeRangeMapper.save(tOperatingmanageNoticeRange);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TOperatingmanageNoticeRange getTOperatingmanageNoticeRangeById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param tOperatingmanageNoticeRange
     * @return
     */
	@Override
	public int updateTOperatingmanageNoticeRange(TOperatingmanageNoticeRange tOperatingmanageNoticeRange) {
		return tOperatingmanageNoticeRangeMapper.update(tOperatingmanageNoticeRange);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += tOperatingmanageNoticeRangeMapper.remove(id);
		}
		return count;
	}

	/**
	 * 根据通知公告id删除范围
	 *
	 * @param noticeId
	 * @return
	 */
	@Override
	public int removeByNoticeId(Long noticeId) {
		return tOperatingmanageNoticeRangeMapper.removeByNoticeId(noticeId);
	}
}
