package com.ruoyi.system.service.grid.impl;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.grid.GridCompanySafeCheckAttachment;
import com.ruoyi.system.domain.grid.GridCompanySafeCheckAttachmentExample;
import com.ruoyi.system.mapper.grid.GridCompanySafeCheckAttachmentMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridCompanySafeCheckAttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
* @author Cesar
* @date  ${cTime}
* @desc CaseSafeCheckAttachmentService实现
*/
@Service
public class GridCompanySafeCheckAttachmentServiceImpl extends BaseServiceImpl<GridCompanySafeCheckAttachmentMapper, GridCompanySafeCheckAttachment, GridCompanySafeCheckAttachmentExample> implements GridCompanySafeCheckAttachmentService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridCompanySafeCheckAttachmentServiceImpl.class);

    @Autowired
    GridCompanySafeCheckAttachmentMapper GridCompanySafeCheckAttachmentMapper;

    @Override
    public List<GridCompanySafeCheckAttachment> listAttachments(String checkId){
        if(StringUtils.isBlank(checkId)){
            return new ArrayList<>();
        }
        GridCompanySafeCheckAttachmentExample example = new GridCompanySafeCheckAttachmentExample();
        example.createCriteria().andSafeCheckIdEqualTo(checkId).andIsValidEqualTo("1");
        example.setOrderByClause(" create_time asc ");
        List<GridCompanySafeCheckAttachment> attachmentList = GridCompanySafeCheckAttachmentMapper.selectByExample(example);
        return attachmentList;
    }

    @Override
    public void saveAttachments(List<GridCompanySafeCheckAttachment> attachments, String checkId){
        GridCompanySafeCheckAttachment params = new GridCompanySafeCheckAttachment();
        params.setIsValid("0");
        GridCompanySafeCheckAttachmentExample example = new GridCompanySafeCheckAttachmentExample();
        example.createCriteria().andSafeCheckIdEqualTo(checkId);
        GridCompanySafeCheckAttachmentMapper.updateByExampleSelective(params, example);
        if(!CollectionUtils.isEmpty(attachments)){
            for(GridCompanySafeCheckAttachment attachment:attachments){
                attachment.setIsValid("1");
                attachment.setCreateTime(DateUtils.getTime());
                attachment.setId(UUID.randomUUID().toString());
                attachment.setSafeCheckId(checkId);
                GridCompanySafeCheckAttachmentMapper.insert(attachment);
            }
        }
    }
}
