package com.ruoyi.system.domain.task;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;

/**
 * 工单 隐患矛盾
 * @TableName tk_common_yinhuan
 */
@TableName(value ="tk_common_yinhuan")
@Data
public class TkCommonYinhuan implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;

    /**
     * 事件名称
     */
    @TableField(value = "title")
    private String title;

    /**
     * 事发时间
     */
    @TableField(value = "happen_time")
    private LocalDateTime happenTime;

    /**
     * 事发地点
     */
    @TableField(value = "address")
    private String address;

    /**
     * 详情
     */
    @TableField(value = "description")
    private String description;

    /**
     * 来源部门
     */
    @TableField(value = "dep_id")
    private Long depId;

    /**
     * 危险程度
     */
    @TableField(value = "danger_flag")
    private String dangerFlag;

    /**
     * 创建人
     */
    @TableField(value = "creator")
    private String creator;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @TableField(value = "update_time")
    private LocalDateTime updateTime;

    /**
     * 是否删除
     */
    @TableField(value = "delete_flag")
    private Boolean deleteFlag;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}