package com.ruoyi.system.domain.md.request;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Objects;

@Setter
@Getter
public class NewMsgUser implements Serializable {

    /**
     * 用户ID
     */
    private String userid;

    /**
     * 部门ID
     */
    private String deptid;

    public NewMsgUser() {
    }

    public NewMsgUser(String userid, String deptid) {
        this.userid = userid;
        this.deptid = deptid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NewMsgUser user = (NewMsgUser) o;
        return Objects.equals(userid, user.userid) &&
                Objects.equals(deptid, user.deptid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userid, deptid);
    }
}
