package com.ruoyi.system.service.grid.impl;

import com.ruoyi.system.domain.grid.GridRegionUser;
import com.ruoyi.system.domain.grid.GridRegionUserExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridRegionUserMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridRegionUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridRegionUserService实现
 */
@Service
@MyBaseService
public class GridRegionUserServiceImpl extends BaseServiceImpl<GridRegionUserMapper, GridRegionUser, GridRegionUserExample> implements GridRegionUserService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridRegionUserServiceImpl.class);

    @Autowired
    GridRegionUserMapper gridRegionUserMapper;

    @Override
    public List<GridRegionUser> selectUsers(String wgCode) {
        GridRegionUserExample ex = new GridRegionUserExample();
        GridRegionUserExample.Criteria ca = ex.createCriteria();
        ca.andWgIdLike(wgCode + "%");
        ca.andIsValidEqualTo("1");
        return this.selectByExample(ex);
    }

    @Override
    public GridRegionUser selectByUserId(String userId) {
        GridRegionUserExample ex = new GridRegionUserExample();
        GridRegionUserExample.Criteria ca = ex.createCriteria();
        ca.andUserIdEqualTo(userId);
        ca.andIsValidEqualTo("1");
        return this.selectFirstByExample(ex);
    }

    @Override
    public List<GridRegionUser> selectRandom(int userNum) {
        return gridRegionUserMapper.selectRandom(userNum);
    }

    @Override
    public List<GridRegionUser> getPermissionWgCodes(String userId) {
        GridRegionUserExample example = new GridRegionUserExample();
        GridRegionUserExample.Criteria criteria = example.createCriteria();
        criteria.andIsValidEqualTo("1");
        criteria.andUserIdEqualTo(userId);
        return gridRegionUserMapper.selectByExample(example);
    }
}
