package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.grid.GridCompanySafeCheck;
import com.ruoyi.system.domain.grid.GridCompanySafeCheckExample;
import com.ruoyi.system.domain.lawcase.vo.CaseSafeCheckCountBean;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckExt;
import com.ruoyi.system.domain.grid.vo.GridCompanySafeCheckParam;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

/**
* @author Cesar
* @date  ${cTime}
* @desc WsCompanySafeCheckService接口
*/
public interface GridCompanySafeCheckService extends BaseService<GridCompanySafeCheck, GridCompanySafeCheckExample> {

    /**
     * 分页查询安监检查列表
     */
    PageInfo pageInfos(GridCompanySafeCheckParam check, Integer pageNo, Integer pageSize);

    /**
     * 获取安监检查详情
     */
    GridCompanySafeCheckExt detail(String id);

    /**
     * 保存安监检查
     */
    void save(GridCompanySafeCheckExt check);

    /**
     * 更新安监检查
     */
    void update(GridCompanySafeCheckExt check);

    /**
     * 删除安监检查
     */
    void delete(String id);

    /**
     * 安监企业最近30天检查数量
     */
    long countThirthNum(String companyId);

    /**
     * 大屏：安监检查统计信息
     * @return
     */
    Map countSafeCheckInfo(String wgCode);

    /**
     * 大屏：安监检查企业检查情况
     */
    Map countCompanyCheckInfo(String wgCode);

    /**
     * 大屏：安监检查村级检查企业数
     */
    List<CaseSafeCheckCountBean> countCountryCheckInfo(String wgCode);

    /**
     * 大屏：安监检查近7天检查情况
     */
    List<Map<String, Object>> countSevenDayCheckInfo(String landId);

    /**
     * 分页查询安监检查列表
     */
    PageInfo countPageInfo(GridCompanySafeCheckParam check, Integer pageNo, Integer pageSize);

    /**
     * 分页查询定点安监检查列表
     */
    PageInfo countPointPageInfo(GridCompanySafeCheckParam check, Integer pageNo, Integer pageSize);
}
