package com.ruoyi.system.service.form;


import com.ruoyi.system.domain.form.MdFormCategory;
import com.ruoyi.system.domain.form.MdFormTemplate;
import com.ruoyi.system.domain.form.MdFormTemplateExample;
import com.ruoyi.system.domain.form.params.FormTemplateQuery;
import com.ruoyi.system.domain.form.vo.FormTemplateCountVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.UUID;

@Service
public class FormTemplateManager {

    @Autowired
    private MdFormTemplateService mdFormTemplateService;

    @Autowired
    private MdFormCategoryService mdFormCategoryService;

    /**
     * @return com.eazytec.zqtong.common.model.AjaxResult
     * @Author wp
     * @Description //模板的创建与更新
     * @Date 13:39 2020/8/17
     * @Param [mdFormTemplate]
     **/
    public int saveOrUpdate(MdFormTemplate mdFormTemplate) {
        mdFormTemplate.setCreateTime(System.currentTimeMillis());
        mdFormTemplate.setStatus(1);
        int count;
        //用于判定name是否重复。
        MdFormTemplateExample example = new MdFormTemplateExample();
        MdFormTemplateExample.Criteria c = example.createCriteria();
        c.andNameEqualTo(mdFormTemplate.getName());
        //新增
        if (StringUtils.isEmpty(mdFormTemplate.getId())) {
            //先判定是否有重复的名称
            int templateNameCount = mdFormTemplateService.countByExample(example);
            if (templateNameCount > 0) throw new RuntimeException("模板名称已存在，请更改！");
            //无重复名称
            mdFormTemplate.setId(UUID.randomUUID().toString());
            count = mdFormTemplateService.insertSelective(mdFormTemplate);
            return count;
        } else {
            //名称name唯一
            c.andIdNotEqualTo(mdFormTemplate.getId());
            int templateNameCount = mdFormTemplateService.countByExample(example);
            if (templateNameCount > 0) throw new RuntimeException("模板名称已存在，请更改！");
            //更新
            count = mdFormTemplateService.updateByPrimaryKeySelective(mdFormTemplate);
            return count;
        }
    }

    /**
     * @return java.lang.Object
     * @Author wp
     * @Description //查询列表。无分页！
     * @Date 13:25 2020/8/17
     * @Param [mdFormTemplate]
     **/
    public Object queryAll(FormTemplateQuery mdFormTemplate) {
        MdFormTemplateExample example = new MdFormTemplateExample();
        MdFormTemplateExample.Criteria c0 = example.createCriteria();
        c0.andStatusEqualTo(1);

        if (StringUtils.isNotEmpty(mdFormTemplate.getCategoryId())) {
            c0.andCategoryIdEqualTo(mdFormTemplate.getCategoryId());
        }

        if (StringUtils.isNotEmpty(mdFormTemplate.getName())) {
            c0.andNameLike(mdFormTemplate.getName());
        }
        if (StringUtils.isNotEmpty(mdFormTemplate.getSelectByOwn())) {
            c0.andOwnUserEqualTo(mdFormTemplate.getSelectByOwn());
            example.setOrderByClause("create_time desc");
            return mdFormTemplateService.selectByExample(example);
        }

        /*---------------增加权限over-------------------*/
        example.setOrderByClause("create_time desc");
        List<MdFormTemplate> templateList = mdFormTemplateService.selectByExample(example);

        if (!CollectionUtils.isEmpty(templateList)) {
            for (MdFormTemplate template : templateList) {

                if (StringUtils.isNotEmpty(template.getCategoryId())) {
                    MdFormCategory category = mdFormCategoryService.selectByPrimaryKey(template.getCategoryId());
                    if (category != null) {
                        template.setCategoryName(category.getName());
                    }
                }
            }
        }
        return templateList;
    }

    public MdFormTemplateExample buildEx(MdFormTemplate query) {
        MdFormTemplateExample example = new MdFormTemplateExample();
        if (query == null) {
            return example;
        }
        MdFormTemplateExample.Criteria c = example.createCriteria();
        //根据人查询
        if (query.getOwnUser() != null) {
            c.andOwnUserEqualTo(query.getOwnUser());
        }
        return example;
    }

    public int deleteById(String categoryId) {
        MdFormTemplate mdFormCategory = new MdFormTemplate();
        mdFormCategory.setId(categoryId);
        mdFormCategory.setStatus(0);
        int count = mdFormTemplateService.updateByPrimaryKeySelective(mdFormCategory);
        return count;
    }

    public Object queryOneWithBlob(String id) {
        MdFormTemplateExample example = new MdFormTemplateExample();
        MdFormTemplateExample.Criteria c = example.createCriteria();
        c.andIdEqualTo(id);
        return mdFormTemplateService.selectFirstByExampleWithBLOBs(example);
    }

    public Object templateCount(MdFormTemplate mdFormTemplate) {
        MdFormTemplateExample example = new MdFormTemplateExample();
        MdFormTemplateExample.Criteria c = example.createCriteria();
        int myCount = 0;
        if (StringUtils.isNotEmpty(mdFormTemplate.getOwnUser())) {
            c.andOwnUserEqualTo(mdFormTemplate.getOwnUser());
            myCount = mdFormTemplateService.countByExample(example);
        }
        MdFormTemplateExample example2 = new MdFormTemplateExample();
        MdFormTemplateExample.Criteria c0 = example2.createCriteria();

        /*---------------增加权限over-------------------*/
        int allCount = mdFormTemplateService.countByExample(example2);
        FormTemplateCountVo formTemplateCountVo = new FormTemplateCountVo();
        formTemplateCountVo.setOwnCount(myCount);
        formTemplateCountVo.setAllCount(allCount);
        return formTemplateCountVo;
    }
}
