package com.ruoyi.system.domain.grid.enums;

/**
 * * Author: brenda
 * * 2024/7/1
 **/
public enum GridCompanyLevelEnum {

    RED("RED", "一级"),

    YELLOW("YELLOW", "二级"),

    GREEN("GREEN", "三级");

    private String code;

    private String value;

    private GridCompanyLevelEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static GridCompanyLevelEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

}
