package com.ruoyi.system.service.house;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ruoyi.system.domain.house.HouseResource;
import com.ruoyi.system.domain.house.vo.*;

import java.util.List;

public interface HouseResourceService {

    void saveHouseResource(HouseResourceSaveUpdateDto dto);

    HouseResourceDetail detail(String id);

    void updateHouseResource(HouseResourceSaveUpdateDto dto);

    void deleteHouseResourceById(String id);

    void batchSaveHouseResources(List<HouseResource> houseResources);

    IPage<HouseResourcePage> pageHouseResources(HouseResourcePageQuery query);

    List<HouseResourceProfileGraph> profileGraphHouseResources(HouseResourcePageQuery query);

    List<HouseResourceProfileGraph> appProfileGraphHouseResources(HouseResourcePageQuery query);

    List<HouseResourcePage> listHouseResources(HouseResourcePageQuery query);

    List<HouseResourcePage> exportListHouseResources(HouseResourcePageQuery query);

    BusinessEntityStatisticsDetail businessEntityStatistics(HouseResourcePageQuery query);

    PageBusinessEntityStatisticsDetail pageBusinessEntityStatistics(PageBusinessEntityStatisticsQuery query);

    void saveYearTax(YearTaxSaveUpdateDto dto);

    List<BusinessEntityDto> listByBusinessEntityInfoName(String name);
}
