package com.ruoyi;

import com.ruoyi.system.domain.task.TkCommonTask;
import com.ruoyi.system.domain.task.enums.TkYinhunBindTypeEnum;
import com.ruoyi.system.domain.task.request.TkCommonYinhuanAddRequest;
import com.ruoyi.system.domain.task.request.TkCommonYinhuanQueryRequest;
import com.ruoyi.system.mapper.task.ext.TkCommonTaskExtMapper;
import com.ruoyi.system.service.task.TkCommonYinhuanService;
import org.assertj.core.util.DateUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author vidar
 * date 2024/6/26
 * description
 **/
@RunWith(SpringRunner.class)
@SpringBootTest
public class TaskTest {
    @Resource
    private TkCommonYinhuanService tkCommonYinhuanService;
    @Resource
    private TkCommonTaskExtMapper tkCommonTaskExtMapper;

    @Test
    public void yinhuanPage(){
        tkCommonYinhuanService.pageVO(new TkCommonYinhuanQueryRequest());
    }

    @Test
    public void add(){
        TkCommonYinhuanAddRequest request = new TkCommonYinhuanAddRequest();
        request.setTitle("隐患矛盾");
        request.setAddress("卓易");
        request.setDescription("啊啊啊");
        request.setDepId(100L);
        request.setDangerFlag("相对危险");
        tkCommonYinhuanService.add(request,"1");
    }

    @Test
    public void matterTask(){
        Map<String, Object> para = new HashMap<String, Object>();
        para.put("startDate", DateUtil.parse("2024-06-01"));
        para.put("wgCode", "320282118");
        List<TkCommonTask> result = tkCommonTaskExtMapper.matterTask(para);
        System.out.println(result);
    }
}
