/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.ElsePart;
import io.termd.core.term.JavaCharStream;
import io.termd.core.term.OpCode;
import io.termd.core.term.ParseException;
import io.termd.core.term.ParserHandler;
import io.termd.core.term.Sequence;
import io.termd.core.term.TermInfoParserConstants;
import io.termd.core.term.TermInfoParserTokenManager;
import io.termd.core.term.Token;
import io.termd.core.util.Logging;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class TermInfoParser
implements TermInfoParserConstants {
    public TermInfoParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public TermInfoParser(String s) {
        this(new StringReader(s));
    }

    public List<String> parseHeaderLine() throws ParseException {
        final ArrayList<String> headerLine = new ArrayList<String>();
        this.parseHeaderLine(new ParserHandler(){

            @Override
            public void beginHeaderLine(String alias) {
                headerLine.add(alias);
            }

            @Override
            public void addHeader(String alias) {
                headerLine.add(alias);
            }
        });
        return headerLine;
    }

    public void parseFeatureLine() throws ParseException {
        this.parseFeatureLine(new ParserHandler());
    }

    public void parseDevice() throws ParseException {
        this.parseDevice(new ParserHandler());
    }

    public void parseDatabase() throws ParseException {
        this.parseDatabase(new ParserHandler());
    }

    private String convertControlChar(String s) {
        char c = s.charAt(0);
        if (c >= '@') {
            c = c >= 'a' && c <= 'z' ? (char)(c - 97 + 65 - 64) : (char)(c - 64);
            return String.valueOf(c);
        }
        throw new UnsupportedOperationException("Invalid control :" + s);
    }

    private String convertEscChar(String s) {
        char c = s.charAt(0);
        switch (c) {
            case 'E': 
            case 'e': {
                c = '\u001b';
                break;
            }
            case 'a': {
                c = '\u0007';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case 'A': {
                c = '\u0001';
                break;
            }
            case ',': 
            case ':': 
            case '\\': 
            case '^': {
                break;
            }
            case 's': {
                c = ' ';
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid escape :" + s);
            }
        }
        return String.valueOf(c);
    }

    public Sequence parseSequence() throws ParseException {
        this.token_source.SwitchTo(4);
        final Sequence[] ref = new Sequence[1];
        this.parseStringFeature("", new ParserHandler(){

            @Override
            public void addStringFeature(String name, Sequence value) {
                ref[0] = value;
            }
        });
        return ref[0];
    }

    public OpCode parseSingleOpCode() throws ParseException {
        this.token_source.SwitchTo(5);
        return this.parseChar();
    }

    public final void parseDatabase(ParserHandler handler) throws ParseException {
        block9: {
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        this.parseDevice(handler);
                        continue block8;
                    }
                    case 5: {
                        this.parseCommentLine();
                        continue block8;
                    }
                    case 6: {
                        this.jj_consume_token(6);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        handler.endDatabase();
    }

    public final void parseDevice(ParserHandler handler) throws ParseException {
        this.parseHeaderLine(handler);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.parseFeatureLine(handler);
        }
        handler.endDevice();
    }

    public final void parseCommentLine() throws ParseException {
        this.jj_consume_token(5);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(10);
        }
        this.jj_consume_token(11);
    }

    public final void parseHeaderLine(ParserHandler handler) throws ParseException {
        Token alias = this.jj_consume_token(4);
        handler.beginHeaderLine(alias.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(8);
            alias = this.jj_consume_token(7);
            handler.addHeader(alias.image);
        }
        this.jj_consume_token(9);
        handler.endHeaderLine();
    }

    public final void parseFeatureLine(ParserHandler handler) throws ParseException {
        this.jj_consume_token(3);
        block3: while (true) {
            this.parseFeature(handler);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_consume_token(13);
    }

    public final void parseFeature(ParserHandler handler) throws ParseException {
        Token name = this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.parseBooleanFeature(name.image, handler);
                break;
            }
            case 14: {
                this.parseStringFeature(name.image, handler);
                break;
            }
            case 15: {
                this.parseNumericFeature(name.image, handler);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parseBooleanFeature(String name, ParserHandler handler) throws ParseException {
        this.jj_consume_token(16);
        if (name.endsWith("@")) {
            handler.addBooleanFeature(name.substring(0, name.length() - 1), false);
        } else {
            handler.addBooleanFeature(name, true);
        }
    }

    public final void parseStringFeature(String name, ParserHandler handler) throws ParseException {
        ArrayList<OpCode> value = new ArrayList<OpCode>();
        try {
            this.jj_consume_token(14);
            block5: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
                OpCode opcode = this.parseChar();
                if (opcode instanceof OpCode.Literal && value.size() > 0 && value.get(value.size() - 1) instanceof OpCode.Literal) {
                    value.set(value.size() - 1, new OpCode.Literal("" + value.get(value.size() - 1) + opcode));
                    continue;
                }
                value.add(opcode);
            }
            this.jj_consume_token(50);
            handler.addStringFeature(name, new Sequence(value));
        }
        catch (ParseException e) {
            Token t;
            Logging.TERMINFO.trace("Could not parse feature " + name);
            do {
                t = this.getNextToken();
            } while (t.kind != 50);
        }
    }

    public final OpCode parseChar() throws ParseException {
        OpCode opcode;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                opcode = this.parseStringLiteral();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                opcode = this.parseOpCode();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Literal parseStringLiteral() throws ParseException {
        StringBuilder buffer = new StringBuilder();
        block3: while (true) {
            char c = this.parseCharLiteral();
            buffer.append(c);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    continue block3;
                }
            }
            break;
        }
        if ("" != null) {
            return new OpCode.Literal(buffer.toString());
        }
        throw new Error("Missing return statement in function");
    }

    public final char parseCharLiteral() throws ParseException {
        char c;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                Token t = this.jj_consume_token(17);
                c = t.image.charAt(0);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                c = '\'';
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 51: {
                        Token t = this.jj_consume_token(51);
                        c = this.convertEscChar(t.image).charAt(0);
                        break block0;
                    }
                    case 53: {
                        Token t = this.jj_consume_token(53);
                        c = (char)Integer.parseInt(t.image, 8);
                        break block0;
                    }
                    case 54: {
                        Token t = this.jj_consume_token(54);
                        c = (char)Integer.parseInt(t.image, 8);
                        break block0;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 20: {
                this.jj_consume_token(20);
                Token t = this.jj_consume_token(55);
                c = this.convertControlChar(t.image).charAt(0);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return c;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode parseOpCode() throws ParseException {
        OpCode opcode;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                opcode = this.parseOpCodePushParam();
                break;
            }
            case 22: {
                opcode = this.parseOpCodePrintf();
                break;
            }
            case 23: {
                opcode = this.parseOpCodePushIntegerConstant();
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                opcode = this.parseOpCodeBit();
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                opcode = this.parseOpCodeArithmetic();
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                opcode = this.parseOpCodeLogical();
                break;
            }
            case 28: {
                opcode = this.parseOpCodePercent();
                break;
            }
            case 45: {
                opcode = this.parseOpCodeAdd1ToParams();
                break;
            }
            case 33: {
                opcode = this.parseOpCodePushStrLen();
                break;
            }
            case 29: {
                opcode = this.parseOpCodePrintChar();
                break;
            }
            case 30: 
            case 31: {
                opcode = this.parseOpCodeVariable();
                break;
            }
            case 32: {
                opcode = this.parseOpCodePushCharConstant();
                break;
            }
            case 46: {
                opcode = this.parseOpCodeExpr();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.If parseOpCodeExpr() throws ParseException {
        ArrayList<OpCode> expr = new ArrayList<OpCode>();
        this.jj_consume_token(46);
        block3: while (true) {
            OpCode opcode = this.parseChar();
            expr.add(opcode);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    continue block3;
                }
            }
            break;
        }
        OpCode.Then thenPart = this.parseThen();
        this.jj_consume_token(49);
        if ("" != null) {
            return new OpCode.If(expr, thenPart);
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Then parseThen() throws ParseException {
        OpCode opcode;
        ArrayList<OpCode> expr = new ArrayList<OpCode>();
        ArrayList<OpCode> elseExpr = new ArrayList<OpCode>();
        OpCode elsePart = null;
        this.jj_consume_token(47);
        block12: while (true) {
            opcode = this.parseChar();
            expr.add(opcode);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    continue block12;
                }
            }
            break;
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                block13: while (true) {
                    opcode = this.parseChar();
                    elseExpr.add(opcode);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: {
                            continue block13;
                        }
                    }
                    break;
                }
                elsePart = new OpCode.Else(elseExpr);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 47: {
                        OpCode.Then thenPart = this.parseThen();
                        elsePart = new OpCode.If(elseExpr, thenPart);
                        break block3;
                    }
                }
                break;
            }
        }
        if ("" != null) {
            return new OpCode.Then((List<OpCode>)expr, (ElsePart)((Object)elsePart));
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Bit parseOpCodeBit() throws ParseException {
        OpCode.Bit opcode;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                opcode = OpCode.Bit.AND;
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                opcode = OpCode.Bit.OR;
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                opcode = OpCode.Bit.XOR;
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                opcode = OpCode.Bit.NEG;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Arithmetic parseOpCodeArithmetic() throws ParseException {
        OpCode.Arithmetic opcode;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                opcode = OpCode.Arithmetic.PLUS;
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                opcode = OpCode.Arithmetic.MINUS;
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                opcode = OpCode.Arithmetic.MUL;
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                opcode = OpCode.Arithmetic.DIV;
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                opcode = OpCode.Arithmetic.MOD;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Logical parseOpCodeLogical() throws ParseException {
        OpCode.Logical opcode;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                opcode = OpCode.Logical.EQ;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                opcode = OpCode.Logical.GT;
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                opcode = OpCode.Logical.LT;
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                opcode = OpCode.Logical.AND;
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                opcode = OpCode.Logical.OR;
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                opcode = OpCode.Logical.NEG;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Percent parseOpCodePercent() throws ParseException {
        this.jj_consume_token(28);
        OpCode.Percent opcode = OpCode.Percent.INSTANCE;
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.Add1ToParams parseOpCodeAdd1ToParams() throws ParseException {
        this.jj_consume_token(45);
        OpCode.Add1ToParams opcode = OpCode.Add1ToParams.INSTANCE;
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.PushStrLen parseOpCodePushStrLen() throws ParseException {
        this.jj_consume_token(33);
        OpCode.PushStrLen opcode = OpCode.PushStrLen.INSTANCE;
        if ("" != null) {
            return opcode;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.PushParam parseOpCodePushParam() throws ParseException {
        Token t = this.jj_consume_token(21);
        if ("" != null) {
            return new OpCode.PushParam(t.image.charAt(2) - 48);
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.PushConstant parseOpCodePushIntegerConstant() throws ParseException {
        Token t = this.jj_consume_token(23);
        if ("" != null) {
            return new OpCode.PushConstant(Integer.parseInt(t.image.substring(2, t.image.length() - 1)), true);
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode parseOpCodePrintf() throws ParseException {
        Token t = this.jj_consume_token(22);
        if ("%+".equals(t.image)) {
            if ("" != null) {
                return OpCode.Arithmetic.PLUS;
            }
        } else if ("%-".equals(t.image)) {
            if ("" != null) {
                return OpCode.Arithmetic.MINUS;
            }
        } else if ("" != null) {
            return OpCode.Printf.parse(t.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.PrintChar parseOpCodePrintChar() throws ParseException {
        this.jj_consume_token(29);
        if ("" != null) {
            return OpCode.PrintChar.INSTANCE;
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode parseOpCodeVariable() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                Token t = this.jj_consume_token(30);
                if ("" == null) break;
                return new OpCode.SetPopVar(t.image.charAt(2));
            }
            case 31: {
                Token t = this.jj_consume_token(31);
                if ("" == null) break;
                return new OpCode.GetPushVar(t.image.charAt(2));
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final OpCode.PushConstant parseOpCodePushCharConstant() throws ParseException {
        this.jj_consume_token(32);
        char c = this.parseCharLiteral();
        this.jj_consume_token(18);
        if ("" != null) {
            return new OpCode.PushConstant(c, false);
        }
        throw new Error("Missing return statement in function");
    }

    public final void parseNumericFeature(String name, ParserHandler handler) throws ParseException {
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: {
                Token t = this.jj_consume_token(58);
                handler.addNumericFeature(name, Integer.parseInt(t.image.substring(2), 16));
                break;
            }
            case 57: {
                Token t = this.jj_consume_token(57);
                handler.addNumericFeature(name, Integer.parseInt(t.image, 8));
                break;
            }
            case 56: {
                Token t = this.jj_consume_token(56);
                handler.addNumericFeature(name, Integer.parseInt(t.image));
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(59);
    }

    public TermInfoParser(InputStream stream) {
        this(stream, null);
    }

    public TermInfoParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TermInfoParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public TermInfoParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new TermInfoParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new TermInfoParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public TermInfoParser(TermInfoParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(TermInfoParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

