package com.ruoyi.system.domain.house.vo;

import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class HouseResourceExport {

    @Excel(name = "所属社区")
    private String wgName2;

    @Excel(name = "所属经营主体")
    private String wgName3;

    @Excel(name = "所属门牌号")
    private String wgName4;

    @Excel(name = "类型", readConverterExp = "1=楼宇,4=道路,5=街区,6=综合体,7=市场")
    private int type;

    @Excel(name = "门面号")
    private String houseNumber;

    @Excel(name = "具体位置")
    private String address;

    @Excel(name = "场所面积")
    private BigDecimal houseArea;

    @Excel(name = "产权类型")
    private String houseResourceAttributeText;

    @Excel(name = "经营（办公）场所状态")
    private String houseResourceTypeText;

    @Excel(name = "产权人归属")
    private String ownership;

    @Excel(name = "产权人联系方式")
    private String houseResourceEquityTel;

    @Excel(name = "租金")
    private BigDecimal unitPrice;

    @Excel(name = "经营主体性质", readConverterExp = "1=个体经营户,2=法人单位（企业）,3=分公司,4=非经营主体")
    private String nature;

    @Excel(name = "经营主体名称")
    private String businessEntityInfoName;

    @Excel(name = "负责人")
    private String principal;

    @Excel(name = "负责人联系方式")
    private String principalTel;

    @Excel(name = "主营业务")
    private String business;

    @Excel(name = "工作人员数量")
    private Integer workerNumber;

    @Excel(name = "注册地是否宜城街道", readConverterExp = "false=否,true=是")
    private Boolean registrationPlaceFlag;

    @Excel(name = "注册地址")
    private String registeredAddress;

    @Excel(name = "行业分类")
    private String industryClassification;

    @Excel(name = "是否规上企业", readConverterExp = "false=否,true=是")
    private Boolean gs;

    @Excel(name = "备注")
    private String remark;

    @Excel(name = "2024营收")
    private BigDecimal YearSell2024;

    @Excel(name = "2025营收")
    private BigDecimal YearSell2025;

    @Excel(name = "经营(办公)场所图片")
    private String houseResourceUrl;

    @Excel(name = "营业执照图片")
    private String businessLicenseUrl;
}
