package com.ruoyi.web.controller.house;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.house.BusinessEntityInfo;
import com.ruoyi.system.domain.house.BusinessEntitySell;
import com.ruoyi.system.domain.house.ContrastIncome;
import com.ruoyi.system.mapper.house.BusinessEntityInfoMapper;
import com.ruoyi.system.mapper.house.BusinessEntitySellMapper;
import com.ruoyi.system.mapper.house.ContrastIncomeMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@RestController
@RequestMapping("/api/contrastIncome")
public class ContrastIncomeController extends BaseController {

    private final ContrastIncomeMapper contrastIncomeMapper;

    private final BusinessEntityInfoMapper businessEntityInfoMapper;

    private final BusinessEntitySellMapper businessEntitySellMapper;

    public ContrastIncomeController(ContrastIncomeMapper contrastIncomeMapper, BusinessEntityInfoMapper businessEntityInfoMapper, BusinessEntitySellMapper businessEntitySellMapper) {
        this.contrastIncomeMapper = contrastIncomeMapper;
        this.businessEntityInfoMapper = businessEntityInfoMapper;
        this.businessEntitySellMapper = businessEntitySellMapper;
    }

    @PutMapping("/start")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult start() {
        List<ContrastIncome> contrastIncomes = contrastIncomeMapper.selectAll();
        for (ContrastIncome contrastIncome : contrastIncomes) {
            contrastIncome.setWgName(contrastIncome.getWgName().replaceAll(" ", ""));
            contrastIncome.setName(contrastIncome.getName().replaceAll(" ", ""));
            contrastIncome.setPrincipal(contrastIncome.getPrincipal().replaceAll(" ", ""));
        }
        for (ContrastIncome contrastIncome : contrastIncomes) {
            System.out.println("当前处理id: " + contrastIncome.getId());
            List<BusinessEntityInfo> businessEntityInfos = businessEntityInfoMapper.selectByName(contrastIncome.getName());
            if (CollectionUtils.isEmpty(businessEntityInfos)) {
                System.out.println("当前名字: " + contrastIncome.getName() + " 下没有找到对应的经营主体");
            } else if (businessEntityInfos.size() != 1) {
                System.out.println("当前名字: " + contrastIncome.getName() + " 有多个对应的经营主体");
            } else {
                BusinessEntityInfo businessEntityInfo = businessEntityInfos.get(0);
                BusinessEntitySell businessEntitySell = businessEntitySellMapper.selectBusinessEntitySellByBusinessEntityInfoId(businessEntityInfo.getId(), 2024);
                if (Objects.nonNull(businessEntitySell)) {
                    businessEntitySell.setYearTax(new BigDecimal(contrastIncome.getIncome()));
                    System.out.println("为businessEntityInfo.getName() = " + businessEntityInfo.getName() + "更新了税收");
                    businessEntitySellMapper.updateBusinessEntitySell(businessEntitySell);
                } else {
                    BusinessEntitySell entitySell = new BusinessEntitySell();
                    entitySell.setId(UUID.randomUUID().toString().replaceAll("-", ""));
                    entitySell.setBusinessEntityInfoId(businessEntityInfo.getId());
                    entitySell.setYear(2024);
                    entitySell.setYearTax(new BigDecimal(contrastIncome.getIncome()));
                    System.out.println("为businessEntityInfo.getName() = " + businessEntityInfo.getName() + " 创建了新的BusinessEntitySell: " + entitySell);
                    businessEntitySellMapper.insertBusinessEntitySell(entitySell);
                }
            }
        }
        System.out.println("处理完成");
        return AjaxResult.success();
    }
}
