package com.ruoyi.system.service.video.impl;


import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.utils.HttpUtils;
import com.ruoyi.system.domain.video.ext.HlsUrlRequest;
import com.ruoyi.system.domain.video.ext.HlsUrlResponse;
import com.ruoyi.system.domain.video.ext.RtspUrlRequest;
import com.ruoyi.system.domain.video.ext.RtspUrlResponse;
import com.ruoyi.system.service.video.IccPreviewService;
import org.springframework.stereotype.Service;

@Service
public class IccPreviewImpl implements IccPreviewService {

    private   String host = "122.193.135.82";
    private  String port = "8443";
    private  String username = "admin";
    private  String password = "Admin123";
    private  String clientId = "duijie1";
    private  String clientSecret = "7fe439aa-5190-4d24-97a1-89df65bfa8b6";
    private  boolean isHttp = false;


    //SDK  RTSP视频流
    public RtspUrlResponse getRtspUrl(RtspUrlRequest rtspUrlRequest){
        RtspUrlResponse response=null;
        OauthConfigUserPwdInfo config = new OauthConfigUserPwdInfo(host, clientId, clientSecret, username, password, isHttp, port);
        try {
            response = HttpUtils.executeJson("/evo-apigw/admin/API/MTS/Video/StartVideo", rtspUrlRequest,null, Method.POST , config, RtspUrlResponse.class);
        } catch (ClientException e) {
            e.printStackTrace();
        }
        if(!response.getCode().equals("1000")) {
            System.err.println("获取rtsp流地址失败:"+response.getErrMsg());
        }
        return response;
    }

    //其他流
    public HlsUrlResponse getHlsUrl(HlsUrlRequest hlsUrlRequest){
        HlsUrlResponse response=null;
        OauthConfigUserPwdInfo config = new OauthConfigUserPwdInfo(host, clientId, clientSecret, username, password, isHttp, port);
        try {
            System.out.println(JSONUtil.toJsonStr(hlsUrlRequest));
            response = HttpUtils.executeJson("/evo-apigw/admin/API/video/stream/realtime", hlsUrlRequest,null, Method.POST , config, HlsUrlResponse.class);
        } catch (ClientException e) {
            e.printStackTrace();
        }
        if(!response.getCode().equals("1000")) {
            System.err.println("获取r流地址失败:"+response.getErrMsg());
        }
        response.getData().setUrl("http://"+host+":1"+response.getData().getUrl().substring(23));
        return response;
    }
}
