package com.ruoyi.system.service.grid.impl;

import com.ruoyi.system.domain.grid.GridShopStaff;
import com.ruoyi.system.domain.grid.GridShopStaffExample;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridShopStaffMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridShopStaffService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridShopStaffService实现
 */
@Service
@MyBaseService
public class GridShopStaffServiceImpl extends BaseServiceImpl<GridShopStaffMapper, GridShopStaff, GridShopStaffExample> implements GridShopStaffService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridShopStaffServiceImpl.class);

    @Autowired
    GridShopStaffMapper wsShopStaffMapper;

    @Override
    public List<GridShopStaff> selecGridShopStaffByPeopleId(String peopleId) {
        GridShopStaffExample ex = new GridShopStaffExample();
        GridShopStaffExample.Criteria ca = ex.createCriteria();
        ca.andPeopleIdEqualTo(peopleId);
        ca.andValidEqualTo(Byte.valueOf("1"));
        ex.setOrderByClause(" create_time desc ");
        return this.selectByExample(ex);
    }
}
