package com.ruoyi.system.service.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTPageModel;
import com.ruoyi.system.domain.grid.GridItemLib;
import com.ruoyi.system.domain.grid.GridItemLibExample;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.BsCommonExample;
import com.ruoyi.system.mapper.grid.GridItemLibMapper;
import com.ruoyi.system.service.other.BsCommonService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: hxc
 * @Date: 2019/2/28 0028 16:04
 * @Description: 日常事项表
 */
@Component
public class GridItemLibFacadeService {

    @Autowired
    private BsCommonService bsCommonService;

    @Autowired
    private GridItemLibService bsSxkService;

    @Autowired
    private GridItemLibMapper bsSxkMapper;

    public void getRoles(String sxfl, String sxmc, Integer pageNum, Integer pageSize, AjaxResult result) {
        if (null == pageNum || pageNum <= 0) {
            pageNum = 1;
        }
        if (null == pageSize || pageSize <= 0) {
            pageSize = 10;
        }
        ZQTPageModel<GridItemLib> appPageModel = new ZQTPageModel<>();
        appPageModel.setRecordCount(0);
        appPageModel.setPageCount(0);
        appPageModel.setCurPage(pageNum);
        appPageModel.setItemList(new ArrayList<>());

        GridItemLibExample example = new GridItemLibExample();
        GridItemLibExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty(sxfl)) {
            criteria.andSxflLike("%" + sxfl + "%");
        }
        if (StringUtils.isNotEmpty(sxmc)) {
            criteria.andSxmcLike("%" + sxmc + "%");
        }

        example.setOrderByClause(" create_time asc ");
        int count = bsSxkService.countByExample(example);
        if (count <= 0) {
            result.buildSuccess("success", appPageModel);
            return;
        }

        List<GridItemLib> roles = bsSxkService.selectByExampleWithBLOBsForStartPage(example, pageNum, pageSize);
        for (int i = 0; i < roles.size(); i++) {
            BsCommonExample example1 = new BsCommonExample();
            BsCommonExample.Criteria criteria1 = example1.createCriteria();
            criteria1.andIsValidEqualTo("1");
            criteria1.andCodeEqualTo(roles.get(i).getSxfl());
            BsCommon bsCommon = bsCommonService.selectFirstByExample(example1);
            roles.get(i).setYlzd2(bsCommon.getName());
        }
        if (null == roles || roles.isEmpty()) {
            result.buildSuccess("success", appPageModel);
            return;
        }
        appPageModel.setCurPage(pageNum);
        appPageModel.setRecordCount(count);
        appPageModel.setPageCount((long) Math.ceil(1.0 * count / pageSize));
        appPageModel.setItemList(roles);
        result.buildSuccess("success", appPageModel);
    }

    public void countSxfl(AjaxResult result) {
        int countAll = bsSxkMapper.countAll();
        int countSxfl = bsSxkMapper.countSxfl();
        Map<String, Integer> map = new HashMap<>(2);
        map.put("countAll", countAll);
        map.put("countSxfl", countSxfl);
        result.buildSuccess("success", map);
    }

    public void countBySxfl(AjaxResult result) {
        List<GridItemLib> countBySxfl = bsSxkMapper.countBySxfl();
        Map<String, List<GridItemLib>> map = new HashMap<>(2);
        map.put("countBySxfl", countBySxfl);
        result.buildSuccess("success", countBySxfl);
    }
}
