package com.ruoyi.web.controller.visit;

import com.alibaba.fastjson2.JSON;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.zqt.ZQTreeNode;
import com.ruoyi.system.domain.grid.vo.GridWgBean;
import com.ruoyi.system.domain.visit.VisitPlanTask;
import com.ruoyi.system.domain.visit.ext.VisitPlanExt;
import com.ruoyi.system.domain.visit.ext.VisitPlanTaskExt;
import com.ruoyi.system.domain.visit.vo.VisitPlanRate;
import com.ruoyi.system.service.visit.VisitPlanService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author hxc
 * @Title:
 * @Package
 * @Description:
 * @date 2022/5/10 13:32
 */
@Api(tags = "走访管理 - 综合执法走访")
@RestController
@RequestMapping("/api/visit/plan")
public class VisitPlanController {

    @Autowired
    private VisitPlanService visitPlanService;

    /**
     * @param pageNum
     * @param pageSize
     * @param planTitle   走访标题
     * @param planType    走访类型
     * @param planTime    发布日期
     * @param planObjType 对象类型-1：房屋，2：企业 3：商铺
     * @return
     */
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public AjaxResult list(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                           @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                           @RequestParam(value = "planFl") String planFl,
                           @RequestParam(value = "planTitle", required = false) String planTitle,
                           @RequestParam(value = "planType", required = false) String planType,
                           @RequestParam(value = "planTime", required = false) String planTime,
                           @RequestParam(value = "planObjType", required = false) String planObjType) {
        try {

            PageInfo<VisitPlanExt> pageInfo = visitPlanService.selectByPage(pageNum, pageSize, planTitle, planType, planTime, planObjType, planFl);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }


    @PostMapping(value = "/add")
    public AjaxResult add(@RequestBody VisitPlanExt wszfPlanExt) {
        visitPlanService.save(wszfPlanExt);
        return AjaxResult.success("success");
    }


    @PostMapping(value = "/update")
    public AjaxResult update(@RequestBody VisitPlanExt wszfPlanExt) {
        visitPlanService.update(wszfPlanExt);
        return AjaxResult.success("success");
    }

    @PostMapping(value = "/updateRecordId")
    public AjaxResult updateRecordId(@RequestBody VisitPlanTask planTask) {
        visitPlanService.updateTaskRecordId(planTask.getId(), planTask.getYlzd3());
        return AjaxResult.success("success");
    }

    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    public AjaxResult delete(@RequestParam(value = "id") String id) {
        visitPlanService.delete(id);
        return AjaxResult.success("success");
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public AjaxResult info(@RequestParam(value = "id") String id) {
        VisitPlanExt visitPlanExt = visitPlanService.info(id);
        return AjaxResult.success(visitPlanExt);
    }

    /**
     * @param pageNum
     * @param pageSize
     * @param planId         计划id
     * @param planTaskStatus 走访状态 1：已走访、2：未走访
     * @param objWgCode      对象wgcode
     * @param startTime      走访开始时间
     * @param endTime        走访结束时间
     * @param objType        走访对象类型-1：企业 2：商铺(九小场所）、3房屋（存房屋类型code）
     * @return
     */
    @RequestMapping(value = "/planTaskPage", method = RequestMethod.GET)
    public AjaxResult planTaskPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                   @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                   @RequestParam(value = "planId") String planId,
                                   @RequestParam(value = "planTaskStatus", required = false) String planTaskStatus,
                                   @RequestParam(value = "objWgCode", required = false) String objWgCode,
                                   @RequestParam(value = "startTime", required = false) String startTime,
                                   @RequestParam(value = "endTime", required = false) String endTime,
                                   @RequestParam(value = "objType", required = false) String objType,
                                   @RequestParam(value = "objName", required = false) String objName) {
        try {

            PageInfo<VisitPlanTaskExt> pageInfo = visitPlanService.planTaskPage(pageNum, pageSize, planId, planTaskStatus, objWgCode, startTime, endTime, objType, objName);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }


    @RequestMapping(value = "/planTaskPageApp", method = RequestMethod.GET)
    public AjaxResult planTaskPageApp(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                      @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                      @RequestParam(value = "userId", required = false) String userId,
                                      @RequestParam(value = "planFl") String planFl,
                                      @RequestParam(value = "objName", required = false) String objName,
                                      @RequestParam(value = "planTaskStatus", required = false) String planTaskStatus,
                                      @RequestParam(value = "objType", required = false) String objType) {
        try {

            PageInfo<VisitPlanTaskExt> pageInfo = visitPlanService.planTaskPageApp(pageNum, pageSize, userId, planTaskStatus, objName, objType, planFl);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }

    @RequestMapping(value = "/getPlanWgTree", method = RequestMethod.GET)
    public AjaxResult getPlanWgTree(@RequestParam(value = "planId") String planId) {
        try {

            ZQTreeNode result = visitPlanService.getPlanWgTree(planId);
            return AjaxResult.success(result);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }


    @RequestMapping(value = "/infoTj", method = RequestMethod.GET)
    public AjaxResult infoTj(String wgCode, @RequestParam(value = "planId") String planId) {
        Map<String, String> result = visitPlanService.infoTj(wgCode, planId);
        return AjaxResult.success(result);
    }

    /**
     * 安全走访统计
     *
     * @return
     */
    @RequestMapping(value = "/aqzfPcTj", method = RequestMethod.GET)
    public AjaxResult aqzfPcTj() {
        Map<String, String> result = visitPlanService.aqzfPcTj();
        return AjaxResult.success(result);
    }

    /**
     * APP企业+九小场所走访统计
     * @return
     */
    @RequestMapping(value = "/app/aqzfTj", method = RequestMethod.GET)
    public AjaxResult appAqzfTj(@RequestParam(value = "startDate", required = false)String startDate,
                                @RequestParam(value = "endDate", required = false)String endDate,
                                @RequestParam(value = "objType")String objType,
                                @RequestParam(value = "wgCode")String wgCode) {
        Map<String, Integer> result = visitPlanService.appAqzfTj(startDate, endDate, objType, wgCode);
        return AjaxResult.success(result);
    }

    @RequestMapping(value = "/rhzfPcTj", method = RequestMethod.GET)
    public AjaxResult rhzfPcTj(String wgCode) {
        Map<String, String> result = visitPlanService.rhzfPcTj(wgCode);
        return AjaxResult.success(result);
    }


    @RequestMapping(value = "/nearSevenDayTaskNum", method = RequestMethod.GET)
    @ResponseBody
    public String nearSevenDayTaskNum(String wgCode, String startTime) {
        List<Map<String, Object>> result = null;
        try {

            result = visitPlanService.nearSevenDayTaskNum(wgCode, startTime);

        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(400, "任务数量获取出错"));
        }
        return JSON.toJSONString(AjaxResult.success("success", result));
    }


    @RequestMapping(value = "/selectAqzfTj", method = RequestMethod.GET)
    @ResponseBody
    public String selectAqzfTj(String wgCode, String year, String month) {
        List<GridWgBean> result = null;
        try {

            result = visitPlanService.selectAqzfTj(wgCode, year + "-" + month);
            if (result.size() >= 5) result = result.subList(0, 5);

        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.error(400, "任务数量获取出错"));
        }
        return JSON.toJSONString(AjaxResult.success("success", result));
    }

    @RequestMapping(value = "/planTaskInfo", method = RequestMethod.GET)
    public AjaxResult planTaskInfo(@RequestParam(value = "id") String id) {
        VisitPlanTaskExt wszfPlanTaskExt = visitPlanService.planTaskInfo(id);
        return AjaxResult.success(wszfPlanTaskExt);
    }


    @PostMapping(value = "/updatePlanTask")
    public AjaxResult updatePlanTask(@RequestBody VisitPlanTaskExt wszfPlanTask) {
        visitPlanService.updatePlanTask(wszfPlanTask);
        return AjaxResult.success("success");
    }


    /**
     * 统计 某个网格员的   安全生产走访 和 网格员入户走访
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/countPlanTaskByUserId", method = RequestMethod.GET)
    public AjaxResult countPlanTaskByUserId(@RequestParam(value = "userId") String userId) {
        Map<String, Object> result = visitPlanService.countPlanTaskByUserId(userId);
        return AjaxResult.success(result);
    }

    /**
     * 走访率 如果有指定月份则统计指定月份的数据，否则统计近六个月的数据
     *
     * @return
     */
    @GetMapping("/tj/rate")
    public AjaxResult getPlanRate(VisitPlanRate wszfPlanRate) {
        return AjaxResult.success(visitPlanService.getPlatRate(wszfPlanRate));
    }


    /**
     * 巡查记录
     *
     * @param objId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/getPatrolRecordPage", method = RequestMethod.GET)
    public AjaxResult getPatrolRecordPage(@RequestParam(value = "objId") String objId,
                                          @RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                          @RequestParam(value = "pageSize", defaultValue = "10") int pageSize) {
        PageInfo<Map<String, Object>> result = visitPlanService.getPatrolRecordPage(objId, pageNum, pageSize);
        return AjaxResult.success(result);
    }


    /**
     * 隐患整改
     *
     * @param objId
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/getYhzgPage", method = RequestMethod.GET)
    public AjaxResult getYhzgPage(@RequestParam(value = "objId") String objId,
                                  @RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                  @RequestParam(value = "pageSize", defaultValue = "10") int pageSize) {
        PageInfo<Map<String, Object>> result = visitPlanService.getYhzgPage(objId, pageNum, pageSize);
        return AjaxResult.success(result);
    }


    /**
     * 走访管理：分页签展示已完成的安全生产和入户走访任务信息（序号，对象，走访时间，走访反馈）
     *
     * @param pageNum
     * @param pageSize
     * @param planFl
     * @param wgCode
     * @return
     */
    @RequestMapping(value = "/planTaskForPage", method = RequestMethod.GET)
    public AjaxResult planTaskForPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                                      @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                      @RequestParam(value = "planFl") String planFl,
                                      @RequestParam(value = "wgCode", required = false) String wgCode) {
        try {

            PageInfo<VisitPlanTaskExt> pageInfo = visitPlanService.planTaskForPage(pageNum, pageSize, wgCode, planFl);
            return AjaxResult.success(pageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return AjaxResult.error(500, "服务器内部错误");
        }
    }


    /**
     * obj_id、user_id 更新任务
     *
     * @param userId
     * @param planTaskStatus
     * @param planTaskFeedback
     * @param objId
     * @param updateTime
     * @param qddkdz           签到打卡地址
     * @return
     */
    @RequestMapping(value = "/updateByPlanTask", method = RequestMethod.GET)
    public AjaxResult updateByPlanTask(
            @RequestParam(value = "userId") String userId,
            @RequestParam(value = "planTaskStatus") String planTaskStatus,
            @RequestParam(value = "planTaskFeedback", required = false) String planTaskFeedback,
            @RequestParam(value = "updateTime", required = false) String updateTime,
            @RequestParam(value = "qddkdz", required = false) String qddkdz,
            @RequestParam(value = "otherappAttachments", required = false) String otherappAttachments,
            @RequestParam(value = "objId") String objId) {
        visitPlanService.updateByPlanTask(userId, planTaskStatus, planTaskFeedback, objId, updateTime, otherappAttachments, qddkdz);
        return AjaxResult.success("success");
    }

    /**
     * 30天内走访日志数量
     *
     * @param objType 1-企业，2-商铺（九小场所）3-房屋
     * @param objId   对象的id
     * @return
     */
    @GetMapping(value = "/visit/count")
    public AjaxResult interviewCount(@RequestParam(value = "objType") String objType,
                                     @RequestParam(value = "objId") String objId) {
        return AjaxResult.success(visitPlanService.latestVisitCount(objType, objId));
    }

}

