package com.ruoyi.system.service.operatingmanage.impl;

import com.ruoyi.common.utils.sql.Query;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComInfo;
import com.ruoyi.system.domain.operatingmanage.TPublicServiceComRecruit;
import com.ruoyi.system.mapper.operatingmanage.TPublicServiceComInfoMapper;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComInfoService;
import com.ruoyi.system.service.operatingmanage.TPublicServiceComRecruitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 企业招聘 企业信息
 * @author wujm<wujm@eazytec.com>
 */
@Service
public class TPublicServiceComInfoServiceImpl implements TPublicServiceComInfoService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Resource
	private TPublicServiceComInfoMapper tPublicServiceComInfoMapper;

	@Autowired
	private TPublicServiceComRecruitService itPublicServiceComRecruitService;

	/** 基础功能不要直接写实现 */
	/**
	* 列表
	* @return
	*/
	private List<TPublicServiceComInfo> list(TPublicServiceComInfo tPublicServiceComInfo) {
		return tPublicServiceComInfoMapper.list(tPublicServiceComInfo);
	}

	/**
	* 查询
	* @param id
	*/
	private TPublicServiceComInfo getObjectById(Long id) {
		Query query = new Query();
		query.put("comId",id);
		return tPublicServiceComInfoMapper.getObjectById(query);
	}

    /**
     * 分页查询
     * @param tPublicServiceComInfo
     * @return
     */
	@Override
	public List<TPublicServiceComInfo> listTPublicServiceComInfo(TPublicServiceComInfo tPublicServiceComInfo) {
		return this.list(tPublicServiceComInfo);
	}

    /**
     * 新增
     * @param tPublicServiceComInfo
     * @return
     */
	@Override
	public int saveTPublicServiceComInfo(TPublicServiceComInfo tPublicServiceComInfo) {
		return tPublicServiceComInfoMapper.save(tPublicServiceComInfo);
	}

    /**
     * 根据id查询
     * @param id
     * @return
     */
	@Override
	public TPublicServiceComInfo getTPublicServiceComInfoById(Long id) {
		return this.getObjectById(id);
	}

    /**
     * 修改
     * @param tPublicServiceComInfo
     * @return
     */
	@Override
	public int updateTPublicServiceComInfo(TPublicServiceComInfo tPublicServiceComInfo) {
		return tPublicServiceComInfoMapper.update(tPublicServiceComInfo);
	}

    /**
     * 删除
     * @param ids
     * @return
     */
	@Override
	public int batchRemove(Long[] ids) {
		int count = 0;
		for(Long id:ids) {
			count += tPublicServiceComInfoMapper.remove(id);
		}
		return count;
	}

	@Override
	public List<TPublicServiceComInfo> listComInfo(TPublicServiceComInfo tPublicServiceComInfo){
		List<TPublicServiceComInfo> comInfos = tPublicServiceComInfoMapper.list(tPublicServiceComInfo);

		Set<Long> comIds = comInfos.stream().map(o->o.getComId()).collect(Collectors.toSet());

		TPublicServiceComRecruit comRecruitParam = new TPublicServiceComRecruit();
		comRecruitParam.setComIds(comIds);
		comRecruitParam.setHiddenType(1);
		List<TPublicServiceComRecruit> comRecruits = itPublicServiceComRecruitService.listTPublicServiceComRecruit(comRecruitParam);

		Map<Long,List<TPublicServiceComRecruit>> comRecruitMap = comRecruits.stream().collect(Collectors.groupingBy(TPublicServiceComRecruit::getComId));

		for(TPublicServiceComInfo comInfo : comInfos){
			if(comRecruitMap.containsKey(comInfo.getComId())){
				comInfo.setComRecruitList(comRecruitMap.get(comInfo.getComId()));
			}
		}

		return comInfos;
	}

	@Override
	public TPublicServiceComInfo getComInfoById(Long id) {
		TPublicServiceComInfo comInfo = this.getObjectById(id);

		TPublicServiceComRecruit comRecruitParam = new TPublicServiceComRecruit();
		comRecruitParam.setComId(id);
		comRecruitParam.setHiddenType(1);
		List<TPublicServiceComRecruit> comRecruits = itPublicServiceComRecruitService.listTPublicServiceComRecruit(comRecruitParam);

		comInfo.setComRecruitList(comRecruits);

		return comInfo;
	}

	/**
	 * 新增
	 * @param tPublicServiceComInfo
	 * @return
	 */
	@Override
	public int saveComInfo(TPublicServiceComInfo tPublicServiceComInfo) {
		return tPublicServiceComInfoMapper.save(tPublicServiceComInfo);
	}
}
