/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.LoggerModel;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;
import java.util.Map;

public class LoggerView
extends ResultView<LoggerModel> {
    @Override
    public void draw(CommandProcess process, LoggerModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        process.write(this.renderLoggerInfo(result.getLoggerInfoMap(), process.width()));
    }

    private String renderLoggerInfo(Map<String, Map<String, Object>> loggerInfos, int width) {
        StringBuilder sb = new StringBuilder(8192);
        for (Map.Entry<String, Map<String, Object>> entry : loggerInfos.entrySet()) {
            Map<String, Object> info = entry.getValue();
            TableElement table = new TableElement(2, 10).leftCellPadding(1).rightCellPadding(1);
            TableElement appendersTable = new TableElement().rightCellPadding(1);
            Class clazz = (Class)info.get("class");
            table.row(Element.label("name").style(Decoration.bold.bold()), Element.label("" + info.get("name"))).row(Element.label("class").style(Decoration.bold.bold()), Element.label("" + clazz.getName())).row(Element.label("classLoader").style(Decoration.bold.bold()), Element.label("" + info.get("classLoader"))).row(Element.label("classLoaderHash").style(Decoration.bold.bold()), Element.label("" + info.get("classLoaderHash"))).row(Element.label("level").style(Decoration.bold.bold()), Element.label("" + info.get("level")));
            if (info.get("effectiveLevel") != null) {
                table.row(Element.label("effectiveLevel").style(Decoration.bold.bold()), Element.label("" + info.get("effectiveLevel")));
            }
            if (info.get("config") != null) {
                table.row(Element.label("config").style(Decoration.bold.bold()), Element.label("" + info.get("config")));
            }
            table.row(Element.label("additivity").style(Decoration.bold.bold()), Element.label("" + info.get("additivity"))).row(Element.label("codeSource").style(Decoration.bold.bold()), Element.label("" + info.get("codeSource")));
            List appenders = (List)info.get("appenders");
            if (appenders != null && !appenders.isEmpty()) {
                for (Map appenderInfo : appenders) {
                    Class appenderClass = (Class)appenderInfo.get("class");
                    appendersTable.row(Element.label("name").style(Decoration.bold.bold()), Element.label("" + appenderInfo.get("name")));
                    appendersTable.row(Element.label("class"), Element.label("" + appenderClass.getName()));
                    appendersTable.row(Element.label("classLoader"), Element.label("" + info.get("classLoader")));
                    appendersTable.row(Element.label("classLoaderHash"), Element.label("" + info.get("classLoaderHash")));
                    if (appenderInfo.get("file") != null) {
                        appendersTable.row(Element.label("file"), Element.label("" + appenderInfo.get("file")));
                    }
                    if (appenderInfo.get("target") != null) {
                        appendersTable.row(Element.label("target"), Element.label("" + appenderInfo.get("target")));
                    }
                    if (appenderInfo.get("blocking") != null) {
                        appendersTable.row(Element.label("blocking"), Element.label("" + appenderInfo.get("blocking")));
                    }
                    if (appenderInfo.get("appenderRef") == null) continue;
                    appendersTable.row(Element.label("appenderRef"), Element.label("" + appenderInfo.get("appenderRef")));
                }
                table.row(Element.label("appenders").style(Decoration.bold.bold()), appendersTable);
            }
            sb.append(RenderUtil.render(table, width)).append('\n');
        }
        return sb.toString();
    }
}

