/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.matcher;

import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SimpleInterfaceMatcher
implements ClassMatcher {
    Set<String> interfaces = new HashSet<String>();

    public SimpleInterfaceMatcher(String ... interfaces) {
        for (String name : interfaces) {
            this.interfaces.add(name);
        }
    }

    public SimpleInterfaceMatcher(Collection<String> interfaces) {
        this.interfaces.addAll(interfaces);
    }

    @Override
    public boolean match(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        loader = ClassLoaderUtils.wrap(loader);
        if (classBeingRedefined != null) {
            return this.match(classBeingRedefined);
        }
        ClassReader reader = new ClassReader(classfileBuffer);
        String clazzName = reader.getClassName();
        String superName = reader.getSuperName();
        String[] interfacesArray = reader.getInterfaces();
        if ((reader.getAccess() & 0x200) != 0) {
            return false;
        }
        if (this.interfaces != null && this.interfaces.contains(clazzName.replace('/', '.'))) {
            return true;
        }
        for (String i : interfacesArray) {
            try {
                Class<?> interfaceClass = loader.loadClass(i.replace('/', '.'));
                if (!this.matchInterface(interfaceClass)) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!"java/lang/Object".equals(superName)) {
            try {
                Class<?> superClass = loader.loadClass(superName.replace('/', '.'));
                if (this.matchClass(superClass)) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean matchInterface(Class<?> i) {
        if (this.interfaces != null && this.interfaces.contains(i.getName())) {
            return true;
        }
        for (Class<?> iter : i.getInterfaces()) {
            if (!this.matchInterface(iter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchClass(Class<?> clazz) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (!this.matchInterface(i)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (Object.class.equals(superclass)) {
            return false;
        }
        return this.matchClass(superclass);
    }

    private boolean match(Class<?> clazz) {
        if (clazz.isInterface()) {
            return this.matchInterface(clazz);
        }
        return this.matchClass(clazz);
    }
}

