package com.ruoyi.system.service.grid.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import com.ruoyi.system.listener.MyBaseService;
import com.ruoyi.system.mapper.grid.GridRegionMapper;
import com.ruoyi.system.mapper.grid.GridRegionUserMapper;
import com.ruoyi.system.service.BaseServiceImpl;
import com.ruoyi.system.service.grid.GridRegionService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridRegionService实现
 */
@Service
@MyBaseService
public class GridRegionServiceImpl extends BaseServiceImpl<GridRegionMapper, GridRegion, GridRegionExample> implements GridRegionService {

    private static final Logger LOGGER = LoggerFactory.getLogger(GridRegionServiceImpl.class);

    @Autowired
    GridRegionMapper gridRegionMapper;

    @Autowired
    GridRegionService gridRegionService;

    @Autowired
    private GridRegionUserMapper gridRegionUserMapper;

    @Override
    public String getWgName(String wgCode) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andWgCodeEqualTo(wgCode);
        ca.andIsValidEqualTo("1");
        GridRegion gridRegion = gridRegionService.selectFirstByExample(ex);
        if (gridRegion != null) {
            return gridRegion.getWgName();
        } else {
            return null;
        }
    }

    @Override
    public String getWgCode(String wgName) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andWgNameEqualTo(wgName);
        ca.andIsValidEqualTo("1");
        GridRegion gridRegion = gridRegionService.selectFirstByExample(ex);
        if (gridRegion != null) {
            return gridRegion.getWgCode();
        } else {
            return null;
        }
    }

    @Override
    public List<GridRegion> getGridRegionMap() {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        return gridRegionService.selectByExample(ex);
    }

    @Override
    public Map<String, String> getMapByWgCodes(List<String> wgCodes) {
        if (CollectionUtils.isEmpty(wgCodes)){
            return new HashMap<>();
        }
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andIsValidEqualTo("1");
        ca.andWgCodeIn(wgCodes);
        List<GridRegion> list = gridRegionService.selectByExample(ex);
        return list.stream().collect(Collectors.toMap(GridRegion::getWgCode, GridRegion::getWgName));
    }

    @Override
    public GridRegion getWgOtherCode(String wgCode) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andWgCodeEqualTo(wgCode);
        ca.andIsValidEqualTo("1");
        GridRegion gridRegion = gridRegionService.selectFirstByExample(ex);
        if (gridRegion != null) {
            if ("4".equals(gridRegion.getLevel())) {
                return this.getWgOtherCode(gridRegion.getWgParentId());
            } else {
                return gridRegion;
            }
        } else {
            return null;
        }
    }

    @Override
    public GridRegion getSecondWgCode(String wgCode) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andWgCodeEqualTo(wgCode);
        ca.andIsValidEqualTo("1");
        GridRegion gridRegion = gridRegionService.selectFirstByExample(ex);
        if (gridRegion != null) {
            if ("2".equals(gridRegion.getLevel())) {
                return gridRegion;
            } else {
                return this.getSecondWgCode(gridRegion.getWgParentId());
            }
        } else {
            return null;
        }
    }

    @Override
    public GridRegion loadDetailByCode(String wgCode) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        ca.andWgCodeEqualTo(wgCode);
        ca.andIsValidEqualTo("1");
        GridRegion gridRegion = gridRegionService.selectFirstByExample(ex);
        return gridRegion;
    }

    @Override
    public List<GridRegion> getChildGridRegion(String wgCode) {
        GridRegionExample ex = new GridRegionExample();
        GridRegionExample.Criteria ca = ex.createCriteria();
        if (StringUtils.isBlank(wgCode)) {
            ca.andLevelEqualTo("2");
        } else {
            ca.andWgParentIdEqualTo(wgCode);
        }
        ca.andIsValidEqualTo("1");
        ca.andWgTypeEqualTo("1");
        return this.selectByExample(ex);
    }

    @Override
    public GridRegion getWgByCode(String wgCode) {
        GridRegionExample gridRegionExample = new GridRegionExample();
        GridRegionExample.Criteria criteria1 = gridRegionExample.createCriteria();
        criteria1.andIsValidEqualTo("1");
        criteria1.andWgCodeEqualTo(wgCode);
        List<GridRegion> gridRegion = gridRegionMapper.selectByExample(gridRegionExample);
        return CollectionUtils.isNotEmpty(gridRegion)?gridRegion.get(0):null;
    }

    @Override
    public List<GridRegion> getByParams(GridRegionSearchParam searchParam) {
        return gridRegionMapper.getByParams(searchParam);
    }

}
