package com.ruoyi.web.controller.party;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.party.domain.ExcellentPartyMember;
import com.ruoyi.party.domain.vo.ExcellentPartyMemberVo;
import com.ruoyi.party.service.api.IExcellentPartyMemberService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 优秀党员Controller
 * 
 * @author ruoyi
 * @date 2024-05-27
 */
@Api(tags = "党建-优秀党员")
@RestController
@RequestMapping("/api/party/excellentPartyMember")
public class ExcellentPartyMemberController extends BaseController
{
    @Autowired
    private IExcellentPartyMemberService excellentPartyMemberService;

    /**
     * 查询优秀党员列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ExcellentPartyMember excellentPartyMember)
    {
        startPage();
        List<ExcellentPartyMemberVo> list = excellentPartyMemberService.selectExcellentPartyMemberList(excellentPartyMember);
        return getDataTable(list);
    }

    /**
     * 导出优秀党员列表
     */
    @Log(title = "优秀党员", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ExcellentPartyMember excellentPartyMember)
    {
        List<ExcellentPartyMemberVo> list = excellentPartyMemberService.selectExcellentPartyMemberList(excellentPartyMember);
        ExcelUtil<ExcellentPartyMemberVo> util = new ExcelUtil<>(ExcellentPartyMemberVo.class);
        util.exportExcel(response, list, "优秀党员数据");
    }

    /**
     * 获取优秀党员详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(excellentPartyMemberService.selectExcellentPartyMemberById(id));
    }

    /**
     * 新增优秀党员
     */
    @Log(title = "优秀党员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ExcellentPartyMember excellentPartyMember)
    {
        return toAjax(excellentPartyMemberService.insertExcellentPartyMember(excellentPartyMember));
    }

    /**
     * 修改优秀党员
     */
    @Log(title = "优秀党员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ExcellentPartyMember excellentPartyMember)
    {
        return toAjax(excellentPartyMemberService.updateExcellentPartyMember(excellentPartyMember));
    }

    /**
     * 删除优秀党员
     */
    @Log(title = "优秀党员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(excellentPartyMemberService.deleteExcellentPartyMemberByIds(ids));
    }

    /**
     * 统计优秀党员总数
     */
    @GetMapping("getGoodPartyMemberCounts")
    public AjaxResult getGoodPartyMemberCounts(Integer year, String beginDate){
        return success(excellentPartyMemberService.queryExcellentPartyMemberCount(year,beginDate));
    }
}
