package com.ruoyi.system.service.zb;

import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.zb.request.WeekReportSaveRequest;
import com.ruoyi.system.domain.zb.vo.ReportUserItem;
import com.ruoyi.system.domain.zb.vo.WeekReportDetail;
import com.ruoyi.system.domain.zb.vo.WeekReportPageItem;
import com.ruoyi.system.domain.zb.vo.WeekReportWithUserDetail;

import java.util.List;

/**
 * * Author: brenda
 * * 2025/1/10
 **/
public interface WeekReportService {

    String save(WeekReportSaveRequest request);

    void update(WeekReportSaveRequest request);

    PageInfo<WeekReportPageItem> page(String title, String year, String week, String userId);

    WeekReportDetail simpleDetail(String reportId);

    WeekReportWithUserDetail reportWithUserDetail(String reportId, String userId);

    PageInfo<WeekReportPageItem> pageForApp(String userId, String title, int pageNum, int pageSize);

    /**
     * 取消自动发布任务
     */
    void cancelAuto();

    //是否配置在了领导里
    boolean isLeader(String userId);

    /**
     * 可以查看的用户列表
     * @param userId
     * @return
     */
    List<String> canSeeUserList(String userId, String reportId);

    /**
     * 是否是只读负责人
     * @param userId
     * @return
     */
    boolean isManager(String userId);

}
