package com.ruoyi.system.service.md.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.system.domain.md.JbWork;
import com.ruoyi.system.domain.md.JbWorkExample;
import com.ruoyi.system.domain.md.JbWorkUser;
import com.ruoyi.system.domain.md.JbWorkUserExample;
import com.ruoyi.system.domain.md.dto.JbWorkBean;
import com.ruoyi.system.domain.md.dto.JbReceiver;
import com.ruoyi.system.service.md.JbWorkService;
import com.ruoyi.system.service.md.JbWorkUserService;
import com.ruoyi.system.service.md.JbTodoService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author vidar
 * date 2024/6/5
 * description
 **/
@Service
public class JbTodoServiceImpl implements JbTodoService {
    @Resource
    private JbWorkService jbWorkService;
    @Resource
    private JbWorkUserService jbWorkUserService;

    @Override
    public IPage<JbWorkBean> get(Integer pageNum, Integer pageSize, String name, String uid, Integer isdone) {
        JbWorkExample jbWorkExample = new JbWorkExample();
        JbWorkExample.Criteria criteria = jbWorkExample.createCriteria();

        if (StringUtils.isNotEmpty(name)) {
            criteria.andNameLike("%" + name + "%");
        }

        List<JbWork> jbWorkList;
        List<JbWorkBean> jbWorkBeanList = new ArrayList<>();
        List<Integer> workIdlist = new ArrayList<>();

        JbWorkUserExample JbWorkUserExample = new JbWorkUserExample();
        JbWorkUserExample.Criteria criteria2 = JbWorkUserExample.createCriteria();

        if (StringUtils.isNotEmpty(uid)) {
            criteria2.andUseridEqualTo(uid);
        }

        if (isdone != null) {
            criteria2.andIsdoneEqualTo((byte) isdone.intValue());
        }

        List<JbWorkUser> list = jbWorkUserService.selectByExample(JbWorkUserExample);
        for (JbWorkUser jbWorkUser : list) {
            workIdlist.add(jbWorkUser.getWorkid());
        }

        int count = 0;

        if (CollectionUtils.isNotEmpty(workIdlist)) {
            criteria.andIdIn(workIdlist);
            jbWorkExample.setOrderByClause("createdTime desc");

            jbWorkList = jbWorkService.selectByExampleWithBLOBsForStartPage(jbWorkExample, pageNum, pageSize);
            count = jbWorkService.countByExample(jbWorkExample);

            if (CollectionUtils.isNotEmpty(jbWorkList)) {
                for (JbWork jbWork : jbWorkList) {
                    JbWorkBean jbWorkBean = getJbWorkBean(jbWork);
                    jbWorkBeanList.add(jbWorkBean);
                }
            }
        }
        return new Page<JbWorkBean>(pageNum,pageSize,count).setRecords(jbWorkBeanList);
    }

    private JbWorkBean getJbWorkBean(JbWork jbWork) {
        JbWorkBean jbWorkBean = new JbWorkBean();
        BeanUtils.copyProperties(jbWork, jbWorkBean);
        // 赋值
        jbWorkBean.setRealname(jbWork.getCreateName());
        return jbWorkBean;
    }

    private List<JbWorkUser> getJbWorkUserListByWorkId(Integer workId) {
        JbWorkUserExample jbWorkUserExample = new JbWorkUserExample();
        jbWorkUserExample.createCriteria().andWorkidEqualTo(workId);
        return jbWorkUserService.selectByExample(jbWorkUserExample);
    }

    private Integer upDatestatus(Integer workTd, String uid, Integer status) {
        JbWorkUser jbWorkUser = new JbWorkUser();
        jbWorkUser.setFinishtime(new Date());
        if (status != null) {
            jbWorkUser.setIsdone((byte) status.intValue());
        }

        JbWorkUserExample jbWorkUserExample = new JbWorkUserExample();
        JbWorkUserExample.Criteria criteria = jbWorkUserExample.createCriteria();
        criteria.andWorkidEqualTo(workTd);
        if (!StringUtils.isBlank(uid)) {
            criteria.andUseridEqualTo(uid);
        }
        return jbWorkUserService.updateByExampleSelective(jbWorkUser, jbWorkUserExample);
    }

    @Override
    @Transactional
    public Integer save(JbWorkBean jbWork) {
        if (StringUtils.isEmpty(jbWork.getName())
                || StringUtils.isEmpty(jbWork.getContent())
                || StringUtils.isEmpty(jbWork.getCreatedby())
                || null == jbWork.getReceiver()
                || jbWork.getReceiver().isEmpty()) {
            throw new ServiceException("body必填参数为空");
        }
        List<JbReceiver> jbReceiverList = jbWork.getReceiver();//接收人
        for (JbReceiver jbReceiver : jbReceiverList) {
            if (StringUtils.isEmpty(jbReceiver.getUid())) {
                throw new ServiceException("接收人uid不能为空");
            }
        }
        int ret = -1;
        Integer id = jbWork.getId();
        if (id == null) {
            ret = this.add(jbWork);// 保存JbWork 以及JbWorkUser ，手机推送等
        }
        return ret;
    }

    private Integer add(JbWorkBean jbWorkBean){
        jbWorkBean.setStatus((byte) 0);
        jbWorkBean.setCreatedtime(new Date());

        JbWork jbWork = new JbWork();
        BeanUtils.copyProperties(jbWorkBean, jbWork);
        int id = jbWorkService.insertAndCreateId(jbWork);// 保存JbWork

        if (id <= 0) {
            return id;
        }
        jbWork.setId(id);

        List<JbReceiver> jbReceiverList = jbWorkBean.getReceiver();

        // 保存JbWorkUser
        for (JbReceiver jbReceiver : jbReceiverList) {
            JbWorkUser workUser = new JbWorkUser();
            workUser.setUserid(jbReceiver.getUid());
            workUser.setWorkid(jbWork.getId());
            workUser.setCreatedtime(new Date());
            workUser.setIsdone((byte) 0);
            jbWorkUserService.insert(workUser);
        }
        return id;
    }

    private void finish(Integer workTd) {
        JbWork jbWork = new JbWork();
        jbWork.setStatus((byte) 1);
        jbWork.setFinishtime(new Date());

        JbWorkExample jbWorkExample = new JbWorkExample();
        JbWorkExample.Criteria criteria = jbWorkExample.createCriteria();
        criteria.andIdEqualTo(workTd);
        jbWorkService.updateByExampleSelective(jbWork, jbWorkExample);
    }

    @Override
    @Transactional
    public int workUserStatus(Integer status, Integer workId, Integer isChangeAll, String uid) {
        if (status == null || workId == null) {
            throw new ServiceException("必填参数workId或status为空");
        }
        int ret;
        // 查询该工作对应的所有办理列表数据
        List<JbWorkUser> jbWorkUserList = this.getJbWorkUserListByWorkId(workId);
        if (CollectionUtils.isEmpty(jbWorkUserList)) {
            return 0;
        }
        if (isChangeAll != null && isChangeAll == 1) {
            ret = this.upDatestatus(workId, null, status);
            if (status == 1) {
                // 设置该条工作状态为已完成
                this.finish(workId);
            }
        } else {
            ret = this.upDatestatus(workId, uid, status);
        }
        return ret;
    }

    @Override
    public void deleteTodo(Integer workId, List<String> uIds) {
        JbWorkUserExample jbWorkUserExample = new JbWorkUserExample();
        JbWorkUserExample.Criteria criteria = jbWorkUserExample.createCriteria();
        criteria.andWorkidEqualTo(workId);
        if (CollectionUtils.isNotEmpty(uIds)) {
            criteria.andUseridIn(uIds);
        }
        jbWorkUserService.deleteByExample(jbWorkUserExample);
    }
}
