package com.ruoyi.system.domain.publicservice;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 公共服务 我发声表
 * @author wujm<wujm@eazytec.com>
 */
public class TPublicServiceIsound implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * 发声ID
	 */
	private Long soundId;
	
	/**
	 * 姓名
	 */
	private String soundName;
	
	/**
	 * 联系方式
	 */
	private String soundPhone;
	
	/**
	 * 编号
	 */
	private String soundCode;
	
	/**
	 * 民意内容
	 */
	private String soundDesc;
	
	/**
	 * 采纳结果 0未审核、1已采纳、2未采纳
	 */
	private String soundResult;
	
	/**
	 * 是否匿名
	 */
	private String checkAnonymous;
	
	/**
	 * 创建人
	 */
	private String createBy;
	
	/**
	 * 创建时间
	 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createTime;
	
	/**
	 * 修改人
	 */
	private String updateBy;
	
	/**
	 * 修改时间
	 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date updateTime;
	
	/**
	 * 是否有效1 有效 0 无效
	 */
	private Integer valid;

	private List<TOtherappAttachment> attachmentList;

	/**
	 * 经度
	 */
	private String longitude;

	/**
	 * 纬度
	 */
	private String latitude;


	public List<TOtherappAttachment> getAttachmentList() {
		return attachmentList;
	}

	public void setAttachmentList(List<TOtherappAttachment> attachmentList) {
		this.attachmentList = attachmentList;
	}
	

	public TPublicServiceIsound() {
		super();
	}

	public String getLongitude() {
		return longitude;
	}

	public void setLongitude(String longitude) {
		this.longitude = longitude;
	}

	public String getLatitude() {
		return latitude;
	}

	public void setLatitude(String latitude) {
		this.latitude = latitude;
	}

	/**
     * setter for soundId
     * @param soundId
     */
	public void setSoundId(Long soundId) {
		this.soundId = soundId;
	}

    /**
     * getter for soundId
     */
	public Long getSoundId() {
		return soundId;
	}
	
    /**
     * setter for soundName
     * @param soundName
     */
	public void setSoundName(String soundName) {
		this.soundName = soundName;
	}

    /**
     * getter for soundName
     */
	public String getSoundName() {
		return soundName;
	}
	
    /**
     * setter for soundPhone
     * @param soundPhone
     */
	public void setSoundPhone(String soundPhone) {
		this.soundPhone = soundPhone;
	}

    /**
     * getter for soundPhone
     */
	public String getSoundPhone() {
		return soundPhone;
	}
	
    /**
     * setter for soundCode
     * @param soundCode
     */
	public void setSoundCode(String soundCode) {
		this.soundCode = soundCode;
	}

    /**
     * getter for soundCode
     */
	public String getSoundCode() {
		return soundCode;
	}
	
    /**
     * setter for soundDesc
     * @param soundDesc
     */
	public void setSoundDesc(String soundDesc) {
		this.soundDesc = soundDesc;
	}

    /**
     * getter for soundDesc
     */
	public String getSoundDesc() {
		return soundDesc;
	}
	
    /**
     * setter for soundResult
     * @param soundResult
     */
	public void setSoundResult(String soundResult) {
		this.soundResult = soundResult;
	}

    /**
     * getter for soundResult
     */
	public String getSoundResult() {
		return soundResult;
	}
	
    /**
     * setter for checkAnonymous
     * @param checkAnonymous
     */
	public void setCheckAnonymous(String checkAnonymous) {
		this.checkAnonymous = checkAnonymous;
	}

    /**
     * getter for checkAnonymous
     */
	public String getCheckAnonymous() {
		return checkAnonymous;
	}
	
    /**
     * setter for createBy
     * @param createBy
     */
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

    /**
     * getter for createBy
     */
	public String getCreateBy() {
		return createBy;
	}
	
    /**
     * setter for createTime
     * @param createTime
     */
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

    /**
     * getter for createTime
     */
	public Date getCreateTime() {
		return createTime;
	}

	public String getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	/**
     * setter for updateTime
     * @param updateTime
     */
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

    /**
     * getter for updateTime
     */
	public Date getUpdateTime() {
		return updateTime;
	}
	
    /**
     * setter for valid
     * @param valid
     */
	public void setValid(Integer valid) {
		this.valid = valid;
	}

    /**
     * getter for valid
     */
	public Integer getValid() {
		return valid;
	}
	
}
