package com.ruoyi.system.service.grid;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompanyEconomy;
import com.ruoyi.system.domain.grid.GridCompanyEconomyExample;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;

/**
* @author Cesar
* @date  ${cTime}
* @desc GridCompanyEconomyService接口
*/
public interface GridCompanyEconomyService extends BaseService<GridCompanyEconomy, GridCompanyEconomyExample> {

    // 根据统一社会信用代码,归属月份查询企业经济数据
    List<GridCompanyEconomy> selectGridCompanyEconomyByCreditCode(String creditCode, String belongTime);

    AjaxResult importExcel(MultipartFile file, String belongTime);

    HashMap<String,Object> getNowYearCount(String wgCode);

    HashMap<String,Object> getMonthCount(Integer year);

    List<GridCompanyEconomy> getTopTenCount(String wgCode,String type);
}
