package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridCompany;
import com.ruoyi.system.domain.grid.GridCompanyEconomy;
import com.ruoyi.system.domain.grid.GridCompanyExample;
import com.ruoyi.system.domain.grid.GridCompanyPeople;
import com.ruoyi.system.domain.grid.ext.GridCompanyExt;
import com.ruoyi.system.domain.grid.vo.GridCompanySearchParam;
import com.ruoyi.system.domain.grid.vo.SimpleGridCompanyItem;
import com.ruoyi.system.service.BaseService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * @author Cesar
 * @date ${cTime}
 * @desc GridCompanyService接口
 */
public interface GridCompanyService extends BaseService<GridCompany, GridCompanyExample> {

    PageInfo page(GridCompany wsCompany, String value);

    AjaxResult add(GridCompany wsCompany);

    AjaxResult edit(GridCompany wsCompany);

    AjaxResult detail(String id);

    AjaxResult delete(String id);

    AjaxResult detailByCreditCode(String creditCode);

    List<GridCompany> otherCompany(String creditCode, String wgCode);

    List<GridCompanyEconomy> economy(String creditCode, String belongTime);

    AjaxResult companyBindPeople(GridCompanyPeople wsCompanyPeople);

    int countByCompanyNameOrCreditCode(String companyName, String creditCode, String id);

    // GridCompanyExt查询字典的value值
    GridCompanyExt selectGridCompanyExt(GridCompanyExt wsCompanyExt);

    GridCompanyExt dealGridCompanyExt(Map<String, String> wgxxbMap, Map<String, String> commonMap, GridCompanyExt wsCompanyExt);

    // 企业类型数量统计
    List<Map<String, Object>> countGridCompany(String wgCode);

    // 企业数量总量统计
    int countAll(String wgCode);

    // 各村社区数量统计
    List<Map<String, Object>> countGridCompanyByGrid();

    // 根据统一社会信用代码,企业名称查询企业
    List<GridCompany> selectGridCompanyByCreditCode(String creditCode, String companyName);

    AjaxResult importExcel(MultipartFile file, String createId);

    // 给双随机用的查询接口
    List<GridCompany> selectCompanyForDoubleRandomLimit();

    List<GridCompany> selectByRandom(int companyNum, String chooseCompanyType);

    List<GridCompany> getAllCompanyList(GridCompanySearchParam param);

    /**
     * 企业点位列表
     * @param wgCode
     * @param name
     * @return
     */
    List<SimpleGridCompanyItem> companyPointList(String wgCode, String name);

}
