package com.ruoyi.party.service.api;

import com.ruoyi.party.domain.ExcellentPartyMember;
import com.ruoyi.party.domain.vo.ExcellentPartyMemberVo;

import java.util.List;

/**
 * 优秀党员Service接口
 * 
 * @author ruoyi
 * @date 2024-05-27
 */
public interface IExcellentPartyMemberService 
{
    /**
     * 查询优秀党员
     * 
     * @param id 优秀党员主键
     * @return 优秀党员
     */
    public ExcellentPartyMember selectExcellentPartyMemberById(Long id);

    /**
     * 查询优秀党员列表
     * 
     * @param excellentPartyMember 优秀党员
     * @return 优秀党员集合
     */
    public List<ExcellentPartyMemberVo> selectExcellentPartyMemberList(ExcellentPartyMember excellentPartyMember);

    /**
     * 新增优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    public int insertExcellentPartyMember(ExcellentPartyMember excellentPartyMember);

    /**
     * 修改优秀党员
     * 
     * @param excellentPartyMember 优秀党员
     * @return 结果
     */
    public int updateExcellentPartyMember(ExcellentPartyMember excellentPartyMember);

    /**
     * 批量删除优秀党员
     * 
     * @param ids 需要删除的优秀党员主键集合
     * @return 结果
     */
    public int deleteExcellentPartyMemberByIds(Long[] ids);

    /**
     * 删除优秀党员信息
     * 
     * @param id 优秀党员主键
     * @return 结果
     */
    public int deleteExcellentPartyMemberById(Long id);

    long queryExcellentPartyMemberCount(Integer year, String beginDate);
}
