package com.ruoyi.web.controller.other;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.other.BsCommon;
import com.ruoyi.system.domain.other.vo.BsCommonVO;
import com.ruoyi.system.service.other.BsCommonService;
import com.ruoyi.system.service.other.impl.FlpzService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.UUID;

/**
 * @Auther: hxc
 * @Date: 2019/6/18 0028 14:09
 * @Description: 分类配置
 */
@RestController
@RequestMapping("/api/flpz")
public class BsFlpzController extends BaseController {
    @Autowired
    private FlpzService flpzService;
    @Autowired
    private BsCommonService bsCommonService;

    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ResponseBody
    public String getCommons(@RequestBody BsCommonVO bsCommonVO) {
        try {
            AjaxResult result = new AjaxResult();

            flpzService.getRoles(bsCommonVO, result);
            return JSON.toJSONString(result);
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.build(500, "服务器内部错误", e.getMessage()));
        }
    }

    @RequestMapping(value = "", method = RequestMethod.DELETE)
    @ResponseBody
    public String delete(@RequestBody BsCommon body) {
        try {
            AjaxResult result = new AjaxResult();
             flpzService.delete(body,result);
            return JSON.toJSONString(result);
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.build(500, "服务器内部错误", e.getMessage()));
        }

    }

    @RequestMapping(value = "", method = RequestMethod.POST)
    @ResponseBody
    public String insert(@RequestBody BsCommon body) {
        try {
            String id = UUID.randomUUID().toString();
            body.setId(id);
            int reslt=bsCommonService.insert(body);
            if(reslt > 0){
                return JSON.toJSONString(AjaxResult.build(200, "", "保存成功"));
            }else{
                return JSON.toJSONString(AjaxResult.build(400, "", "保存失败"));
            }
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.build(500, "服务器内部错误", e.getMessage()));
        }

    }

    @RequestMapping(value = "", method = RequestMethod.PATCH)
    @ResponseBody
    public String update(@RequestBody BsCommon body) {
        try {
            int reslt= bsCommonService.updateByPrimaryKeySelective(body);
            if(reslt > 0){
                return JSON.toJSONString(AjaxResult.build(200, "", "保存成功"));
            }else{
                return JSON.toJSONString(AjaxResult.build(400, "", "保存失败"));
            }
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.build(500, "服务器内部错误", e.getMessage()));
        }
    }

    @RequestMapping(value = "/getTreeNode", method = RequestMethod.POST)
    @ResponseBody
    public String getTreeNode(@RequestBody BsCommonVO bsCommonVO) {
        try {
            AjaxResult result = new AjaxResult();
            flpzService.getTreeNode(bsCommonVO, result);

            return JSON.toJSONString(result);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }




    @RequestMapping(value = "/getWgNameList", method = RequestMethod.GET)
    @ResponseBody
    public String getWgNameList(String name,Integer pageNum,Integer pageSize) {
        try {
            AjaxResult result = new AjaxResult();
            List<BsCommon> wgdxList = flpzService.getWgNameList(pageNum,pageSize,name,result);
            return JSON.toJSONString(result);
        } catch (Exception e) {
            e.printStackTrace();
            return JSON.toJSONString(AjaxResult.build(500, "服务器内部错误", e.getMessage()));
        }
    }


}
