/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.DashboardModel;
import com.taobao.arthas.core.command.model.GcInfoVO;
import com.taobao.arthas.core.command.model.MemoryEntryVO;
import com.taobao.arthas.core.command.model.RuntimeInfoVO;
import com.taobao.arthas.core.command.model.TomcatInfoVO;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.command.view.ViewRenderUtil;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DashboardView
extends ResultView<DashboardModel> {
    @Override
    public void draw(CommandProcess process, DashboardModel result) {
        int threadTopHeight;
        int width = process.width();
        int height = process.height();
        int totalHeight = height - 1;
        if (totalHeight <= 24) {
            threadTopHeight = totalHeight / 2;
        } else {
            threadTopHeight = totalHeight / 3;
            if (threadTopHeight < 12) {
                threadTopHeight = 12;
            }
        }
        int lowerHalf = totalHeight - threadTopHeight;
        int memoryInfoHeight = lowerHalf / 2;
        if (memoryInfoHeight < 8) {
            memoryInfoHeight = Math.min(8, lowerHalf);
        }
        TableElement runtimeInfoTable = DashboardView.drawRuntimeInfo(result.getRuntimeInfo());
        TableElement tomcatInfoTable = this.drawTomcatInfo(result.getTomcatInfo());
        int runtimeInfoHeight = Math.max(runtimeInfoTable.getRows().size(), tomcatInfoTable == null ? 0 : tomcatInfoTable.getRows().size());
        if (runtimeInfoHeight < lowerHalf - memoryInfoHeight) {
            memoryInfoHeight = lowerHalf - runtimeInfoHeight;
        } else {
            runtimeInfoHeight = lowerHalf - memoryInfoHeight;
        }
        int maxMemoryInfoHeight = DashboardView.getMemoryInfoHeight(result.getMemoryInfo());
        memoryInfoHeight = Math.min(memoryInfoHeight, maxMemoryInfoHeight);
        threadTopHeight = totalHeight - memoryInfoHeight - runtimeInfoHeight;
        String threadInfo = ViewRenderUtil.drawThreadInfo(result.getThreads(), width, threadTopHeight);
        String memoryAndGc = DashboardView.drawMemoryInfoAndGcInfo(result.getMemoryInfo(), result.getGcInfos(), width, memoryInfoHeight);
        String runTimeAndTomcat = this.drawRuntimeInfoAndTomcatInfo(runtimeInfoTable, tomcatInfoTable, width, runtimeInfoHeight);
        process.write(threadInfo + memoryAndGc + runTimeAndTomcat);
    }

    static String drawMemoryInfoAndGcInfo(Map<String, List<MemoryEntryVO>> memoryInfo, List<GcInfoVO> gcInfos, int width, int height) {
        TableElement table = new TableElement(1, 1);
        TableElement memoryInfoTable = DashboardView.drawMemoryInfo(memoryInfo);
        TableElement gcInfoTable = DashboardView.drawGcInfo(gcInfos);
        table.row(memoryInfoTable, gcInfoTable);
        return RenderUtil.render(table, width, height);
    }

    private static TableElement drawMemoryInfo(Map<String, List<MemoryEntryVO>> memoryInfo) {
        TableElement table = new TableElement(3, 1, 1, 1, 1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("Memory", "used", "total", "max", "usage"));
        List<MemoryEntryVO> heapMemoryEntries = memoryInfo.get("heap");
        for (MemoryEntryVO memoryEntryVO : heapMemoryEntries) {
            if ("heap".equals(memoryEntryVO.getName())) {
                new MemoryEntry(memoryEntryVO).addTableRow(table, Decoration.bold.bold());
                continue;
            }
            new MemoryEntry(memoryEntryVO).addTableRow(table);
        }
        List<MemoryEntryVO> nonheapMemoryEntries = memoryInfo.get("nonheap");
        for (MemoryEntryVO memoryEntryVO : nonheapMemoryEntries) {
            if ("nonheap".equals(memoryEntryVO.getName())) {
                new MemoryEntry(memoryEntryVO).addTableRow(table, Decoration.bold.bold());
                continue;
            }
            new MemoryEntry(memoryEntryVO).addTableRow(table);
        }
        List<MemoryEntryVO> list = memoryInfo.get("buffer_pool");
        if (list != null) {
            for (MemoryEntryVO memoryEntryVO : list) {
                new MemoryEntry(memoryEntryVO).addTableRow(table);
            }
        }
        return table;
    }

    private static int getMemoryInfoHeight(Map<String, List<MemoryEntryVO>> memoryInfo) {
        int height = 1;
        for (List<MemoryEntryVO> memoryEntryVOS : memoryInfo.values()) {
            height += memoryEntryVOS.size();
        }
        return height;
    }

    private static TableElement drawGcInfo(List<GcInfoVO> gcInfos) {
        TableElement table = new TableElement(1, 1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("GC", ""));
        for (GcInfoVO gcInfo : gcInfos) {
            table.add(new RowElement().style(Decoration.bold.bold()).add("gc." + gcInfo.getName() + ".count", "" + gcInfo.getCollectionCount()));
            table.row("gc." + gcInfo.getName() + ".time(ms)", "" + gcInfo.getCollectionTime());
        }
        return table;
    }

    String drawRuntimeInfoAndTomcatInfo(TableElement runtimeInfoTable, TableElement tomcatInfoTable, int width, int height) {
        if (height <= 0) {
            return "";
        }
        TableElement resultTable = new TableElement(1, 1);
        if (tomcatInfoTable != null) {
            resultTable.row(runtimeInfoTable, tomcatInfoTable);
        } else {
            resultTable = runtimeInfoTable;
        }
        return RenderUtil.render(resultTable, width, height);
    }

    private static TableElement drawRuntimeInfo(RuntimeInfoVO runtimeInfo) {
        TableElement table = new TableElement(1, 1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("Runtime", ""));
        table.row("os.name", runtimeInfo.getOsName());
        table.row("os.version", runtimeInfo.getOsVersion());
        table.row("java.version", runtimeInfo.getJavaVersion());
        table.row("java.home", runtimeInfo.getJavaHome());
        table.row("systemload.average", String.format("%.2f", runtimeInfo.getSystemLoadAverage()));
        table.row("processors", "" + runtimeInfo.getProcessors());
        table.row("timestamp/uptime", new Date(runtimeInfo.getTimestamp()).toString() + "/" + runtimeInfo.getUptime() + "s");
        return table;
    }

    private static String formatBytes(long size) {
        int unit = 1;
        String unitStr = "B";
        if (size / 1024L > 0L) {
            unit = 1024;
            unitStr = "K";
        } else if (size / 1024L / 1024L > 0L) {
            unit = 0x100000;
            unitStr = "M";
        }
        return String.format("%d%s", size / (long)unit, unitStr);
    }

    private TableElement drawTomcatInfo(TomcatInfoVO tomcatInfo) {
        if (tomcatInfo == null) {
            return null;
        }
        TableElement table = new TableElement(1, 1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("Tomcat", ""));
        if (tomcatInfo.getConnectorStats() != null) {
            for (TomcatInfoVO.ConnectorStats connectorStat : tomcatInfo.getConnectorStats()) {
                table.add(new RowElement().style(Decoration.bold.bold()).add("connector", connectorStat.getName()));
                table.row("QPS", String.format("%.2f", connectorStat.getQps()));
                table.row("RT(ms)", String.format("%.2f", connectorStat.getRt()));
                table.row("error/s", String.format("%.2f", connectorStat.getError()));
                table.row("received/s", DashboardView.formatBytes(connectorStat.getReceived()));
                table.row("sent/s", DashboardView.formatBytes(connectorStat.getSent()));
            }
        }
        if (tomcatInfo.getThreadPools() != null) {
            for (TomcatInfoVO.ThreadPool threadPool : tomcatInfo.getThreadPools()) {
                table.add(new RowElement().style(Decoration.bold.bold()).add("threadpool", threadPool.getName()));
                table.row("busy", "" + threadPool.getBusy());
                table.row("total", "" + threadPool.getTotal());
            }
        }
        return table;
    }

    static class MemoryEntry {
        String name;
        long used;
        long total;
        long max;
        int unit;
        String unitStr;

        public MemoryEntry(String name, long used, long total, long max) {
            this.name = name;
            this.used = used;
            this.total = total;
            this.max = max;
            this.unitStr = "K";
            this.unit = 1024;
            if (used / 1024L / 1024L > 0L) {
                this.unitStr = "M";
                this.unit = 0x100000;
            }
        }

        public MemoryEntry(String name, MemoryUsage usage) {
            this(name, usage.getUsed(), usage.getCommitted(), usage.getMax());
        }

        public MemoryEntry(MemoryEntryVO memoryEntryVO) {
            this(memoryEntryVO.getName(), memoryEntryVO.getUsed(), memoryEntryVO.getTotal(), memoryEntryVO.getMax());
        }

        private String format(long value) {
            String valueStr = "-";
            if (value == -1L) {
                return "-1";
            }
            if (value != Long.MIN_VALUE) {
                valueStr = value / (long)this.unit + this.unitStr;
            }
            return valueStr;
        }

        public void addTableRow(TableElement table) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            if (Double.isNaN(usage) || Double.isInfinite(usage)) {
                usage = 0.0;
            }
            table.row(this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage));
        }

        public void addTableRow(TableElement table, Style.Composite style) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            if (Double.isNaN(usage) || Double.isInfinite(usage)) {
                usage = 0.0;
            }
            table.add(new RowElement().style(style).add(this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage)));
        }
    }
}

