/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.model.StackModel;
import com.taobao.arthas.core.command.monitor200.StackCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.arthas.core.util.ThreadUtil;
import java.util.Date;

public class StackAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(StackAdviceListener.class);
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private StackCommand command;
    private CommandProcess process;

    public StackAdviceListener(StackCommand command, CommandProcess process, boolean verbose) {
        this.command = command;
        this.process = process;
        super.setVerbose(verbose);
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) throws Throwable {
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        this.finishing(advice);
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        this.finishing(advice);
    }

    private void finishing(Advice advice) {
        try {
            double cost = this.threadLocalWatch.costInMillis();
            boolean conditionResult = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
            if (this.isVerbose()) {
                this.process.write("Condition express: " + this.command.getConditionExpress() + " , result: " + conditionResult + "\n");
            }
            if (conditionResult) {
                StackModel stackModel = ThreadUtil.getThreadStackModel(advice.getLoader(), Thread.currentThread());
                stackModel.setTs(new Date());
                this.process.appendResult(stackModel);
                this.process.times().incrementAndGet();
                if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                    this.abortProcess(this.process, this.command.getNumberOfLimit());
                }
            }
        }
        catch (Throwable e) {
            logger.warn("stack failed.", e);
            this.process.end(-1, "stack failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
        }
    }
}

