package com.ruoyi.system.mapper.grid;

import com.ruoyi.system.domain.grid.GridRegion;
import com.ruoyi.system.domain.grid.GridRegionExample;
import com.ruoyi.system.domain.grid.enums.GridRegionSearchParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface GridRegionMapper {
    long countByExample(GridRegionExample example);

    int deleteByExample(GridRegionExample example);

    int deleteByPrimaryKey(String id);

    int insert(GridRegion record);

    int insertSelective(GridRegion record);

    List<GridRegion> selectByExample(GridRegionExample example);
    List<GridRegion> selectByExampleWithBLOBs(GridRegionExample example);

    GridRegion selectByPrimaryKey(String id);
    GridRegion getWgLevel(@Param("wgCode") String wgCode);
    String getRootWgCode();
    String getWgNameByCode(@Param("wgCode") String wgCode);

    int updateByExampleSelective(@Param("record") GridRegion record, @Param("example") GridRegionExample example);

    int updateByExampleWithBLOBs(@Param("record") GridRegion record, @Param("example") GridRegionExample example);

    int updateByExample(@Param("record") GridRegion record, @Param("example") GridRegionExample example);

    int updateByPrimaryKeySelective(GridRegion record);

    int updateByPrimaryKeyWithBLOBs(GridRegion record);

    int updateByPrimaryKey(GridRegion record);
    //三级网格信息
    List<GridRegion> selectThirdGridByBaseId();

    List<GridRegion> selectThirdGridNameByBaseId();

    List<GridRegion> getByParams(GridRegionSearchParam param);

    Integer countByParams(GridRegionSearchParam param);

    List<GridRegion> getSecondOrThirdRegion(@Param("wgType")String wgType, @Param("wgCodeLikes")List<String> wgCodeLikes, @Param("name")String name, @Param("level")String level);

    String getWgTypeByWgCode(@Param("wgCode")String wgCode);

    List<GridRegion> getRegionByTypeAndCode(@Param("wgType")String wgType, @Param("wgCodeLikes")List<String> wgCodeLikes, @Param("level")String level);

    List<GridRegion> getAllLevelThreeByType(@Param("type") String type,@Param("code") String code);

    List<GridRegion> getAllLevelFourByType(@Param("type") String type,@Param("code") String code);

    int changeTreeNodeName(@Param("id") String id, @Param("name") String name);

    List<GridRegion> getAllLevelTwoByType(@Param("wgCodeLikes")List<String> wgCodeLikes);

    String getWgCodeById(String id);

    List<GridRegion> selectAllByIdAndWgType(@Param("wgType")String wgType, @Param("wgCode")String wgCode);

    int changeTreeNodeNameByCode(@Param("code") String code, @Param("name") String name);

    String getRegionDetail(@Param("id")String id);

    int updateRegionDetail(@Param("id")String id,@Param("detail")String detail);

    String getRegionJzArea(@Param("id")String id);

    int updateRegionJzArea(@Param("id")String id,@Param("jzArea")String jzArea);

    String getJzAreaByCode(@Param("code")String code);
}