package com.ruoyi.web.controller.publicservice;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.publicservice.TPublicServiceResource;
import com.ruoyi.system.service.publicservice.TPublicServiceResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 资源
 * @author wujm<wujm@eazytec.com>
 */
@Api(tags = "公共服务-生活集市")
@RestController
@RequestMapping("/api/publicservice/resource")
public class TPublicServiceResourceController extends BaseController {
	
	@Autowired
	private TPublicServiceResourceService tPublicServiceResourceService;

	@ApiOperation("最大no")
	@GetMapping(value = "/getMaxNo")
	public AjaxResult getMaxNo(TPublicServiceResource tPublicServiceResource) {
		return AjaxResult.success(tPublicServiceResourceService.getMaxNum(tPublicServiceResource));
	}

	/**
	 * 列表
	 * @param tPublicServiceResource
	 * @return
	 */
	@ApiOperation("列表")
	@GetMapping(value = "/list")
	public TableDataInfo list(TPublicServiceResource tPublicServiceResource) {
		startPage();
		return getDataTable(tPublicServiceResourceService.listResource(tPublicServiceResource));
	}
		
	/**
	 * 新增
	 * @param tPublicServiceResource
	 * @return
	 */
	@ApiOperation("新增")
	@Log(title = "新增资源", businessType = BusinessType.INSERT)
	@PostMapping("/save")
	public AjaxResult save(@RequestBody TPublicServiceResource tPublicServiceResource) {
		tPublicServiceResource.setCreateBy(getUserId());
		return toAjax(tPublicServiceResourceService.saveResource(tPublicServiceResource));
	}
	
	/**
	 * 根据id查询详情
	 * @param id
	 * @return
	 */
	@ApiOperation("详情")
	@GetMapping("/{id}")
	public AjaxResult getById(@PathVariable("id") Long id) {
		return AjaxResult.success(tPublicServiceResourceService.getResourceById(id));
	}
	
	/**
	 * 修改
	 * @param tPublicServiceResource
	 * @return
	 */
	@ApiOperation("修改")
	@Log(title = "修改资源", businessType = BusinessType.UPDATE)
	@PutMapping("/update")
	public AjaxResult update(@RequestBody TPublicServiceResource tPublicServiceResource) {
		tPublicServiceResource.setUpdateBy(getUserId());
		return toAjax(tPublicServiceResourceService.updateResource(tPublicServiceResource, getUsername()));
	}
	
	/**
	 * 删除
	 * @param ids
	 * @return
	 */
	@ApiOperation("删除")
	@Log(title = "删除资源", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete")
	public AjaxResult batchRemove(@RequestBody Long[] ids) {
		return toAjax(tPublicServiceResourceService.batchRemove(ids));
	}
	
}
