package com.ruoyi.web.controller.grid;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridWgLog;
import com.ruoyi.system.service.grid.GridWgLogService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : peter
 * @description: TODO
 * @date : 2022-08-18 15:34
 */
@Api(tags = "网格管理 - 网格日志")
@RestController
@RequestMapping("/api/grid/wgLog")
public class GridWgLogController {

    @Autowired
    private GridWgLogService gridWgLogService;

    @GetMapping(value = "/infoAll")
    public AjaxResult infoAll(@RequestParam(value = "wgCode", required = false) String wgCode,
                              @RequestParam(value = "startTime", required = false) String startTime,
                              @RequestParam(value = "endTime", required = false) String endTime) {
        return AjaxResult.success(gridWgLogService.infoAll(wgCode, startTime, endTime));
    }

    /**
     * @param pageNum
     * @param pageSize
     * @param type      对象类型 1-人口 2-住宅 3-企业 4-商铺
     * @param operate   操作类型 insert/update/bind/interview
     * @param startTime
     * @param endTime
     * @return
     */
    @GetMapping(value = "/infoPage")
    public AjaxResult infoPage(@RequestParam(value = "pageNum", defaultValue = "1") int pageNum,
                               @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                               @RequestParam(value = "objectId", required = false) String objectId,
                               @RequestParam(value = "type") String type,
                               @RequestParam(value = "operate") String operate,
                               @RequestParam(value = "startTime", required = false) String startTime,
                               @RequestParam(value = "endTime", required = false) String endTime) {
        PageHelper.startPage(pageNum, pageSize);
        PageInfo<GridWgLog> pageInfo = new PageInfo<>(gridWgLogService.infoPage(objectId, type, operate, startTime, endTime));
        return AjaxResult.success(pageInfo);
    }

}
