/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;

    public PathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t != null && t.isScalarValue()) {
            return Paths.get(p.getValueAsString(), new String[0]);
        }
        throw ctxt.mappingException(Path.class, t);
    }
}

