/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.TermServer;
import com.taobao.arthas.core.shell.term.impl.Helper;
import com.taobao.arthas.core.shell.term.impl.TermImpl;
import io.termd.core.function.Consumer;
import io.termd.core.telnet.netty.NettyTelnetTtyBootstrap;
import io.termd.core.tty.TtyConnection;
import java.util.concurrent.TimeUnit;

public class TelnetTermServer
extends TermServer {
    private static final Logger logger = LoggerFactory.getLogger(TelnetTermServer.class);
    private NettyTelnetTtyBootstrap bootstrap;
    private String hostIp;
    private int port;
    private long connectionTimeout;
    private Handler<Term> termHandler;

    public TelnetTermServer(String hostIp, int port, long connectionTimeout) {
        this.hostIp = hostIp;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer listen(Handler<Future<TermServer>> listenHandler) {
        this.bootstrap = new NettyTelnetTtyBootstrap().setHost(this.hostIp).setPort(this.port);
        try {
            this.bootstrap.start(new Consumer<TtyConnection>(){

                @Override
                public void accept(TtyConnection conn) {
                    TelnetTermServer.this.termHandler.handle(new TermImpl(Helper.loadKeymap(), conn));
                }
            }).get(this.connectionTimeout, TimeUnit.MILLISECONDS);
            listenHandler.handle(Future.succeededFuture());
        }
        catch (Throwable t) {
            logger.error("Error listening to port " + this.port, t);
            listenHandler.handle(Future.failedFuture(t));
        }
        return this;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<Future<Void>> completionHandler) {
        if (this.bootstrap != null) {
            this.bootstrap.stop();
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        } else if (completionHandler != null) {
            completionHandler.handle(Future.failedFuture("telnet term server not started"));
        }
    }

    @Override
    public int actualPort() {
        return this.bootstrap.getPort();
    }
}

