package com.ruoyi.system.service.video.impl;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.model.v202010.OauthConfigUserPwdInfo;
import com.dahuatech.icc.oauth.utils.HttpUtils;
import com.ruoyi.system.domain.video.ext.OperationVO;
import com.ruoyi.system.domain.video.ext.RemoteCaptureRequest;
import com.ruoyi.system.domain.video.ext.RemoteCaptureResponse;
import com.ruoyi.system.domain.video.util.IccToken;
import com.ruoyi.system.service.video.IccCutPicService;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service
public class IccCutPicImpl implements IccCutPicService {
    private   String host = "122.193.135.82";
    private  String port = "8443";
    private  String username = "admin";
    private  String password = "Admin123";
    private  String clientId = "duijie1";
    private  String clientSecret = "7fe439aa-5190-4d24-97a1-89df65bfa8b6";
    private  boolean isHttp = false;

    //截图
    public String remoteCapture(Long id,String channelId) throws Exception {
        //获取http请求
        RemoteCaptureRequest remoteCaptureRequest = operateRemoteCaptureRequest(id,channelId);
        RemoteCaptureResponse response=null;
        //登录信息
        OauthConfigUserPwdInfo config = new OauthConfigUserPwdInfo(host, clientId, clientSecret, username, password, isHttp, port);
        try {
            //http执行
            response = HttpUtils.executeJson("/evo-apigw/admin/API/EVO/invoke/DMS", remoteCaptureRequest,null, Method.POST , config, RemoteCaptureResponse.class);
        } catch (ClientException e) {
            e.printStackTrace();
        }
        if(!response.getCode().equals("1000")) {
            System.err.println("远程设备抓图失败："+response.getDesc());
        }
        Map data = JSONUtil.toBean(response.getData(), Map.class);
        Map params = (Map) data.get("params");
        String PicInfo = (String) params.get("PicInfo");
//        System.out.println(PicInfo);
        String access_token = new IccToken().getToken();
        String url = "https://"+host+":"+port+"/evo-apigw/evo-oss/"+PicInfo+"?token="+access_token;
//        System.out.println(url);

        return url;
    }

    //http参数封装
    public RemoteCaptureRequest operateRemoteCaptureRequest(Long id, String channelId){
        String deviceCode=null,DevChannel;
        //截图操作类型封装
        OperationVO operationVO = new OperationVO();
        //消息id
        operationVO.setId(id);
        //截图设备操作设置
        OperationVO.DeviceVO params = new OperationVO.DeviceVO();
        if(!StringUtils.isEmpty(channelId)){
            //从channelId中截取设备code
            deviceCode = channelId.substring(0,channelId.indexOf("$"));
            params.setDevID(deviceCode);
            //截取channelId编号
            DevChannel = channelId.substring(channelId.lastIndexOf("$")+1);
            params.setDevChannel(DevChannel);
        }
        operationVO.setParams(params);
        //封装http请求
        RemoteCaptureRequest remoteCaptureRequest = new RemoteCaptureRequest();
        remoteCaptureRequest.setDeviceCode(deviceCode);
        remoteCaptureRequest.setParams(JSONUtil.toJsonStr(operationVO));
        return remoteCaptureRequest;
    }

}
