package com.ruoyi.system.service.grid;

import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.grid.GridGroupLand;
import com.ruoyi.system.domain.grid.GridGroupLandExample;
import com.ruoyi.system.domain.grid.ext.GridGroupExt;
import com.ruoyi.system.service.BaseService;

import java.util.List;
import java.util.Map;

/**
 * @author yaoqiang
 * @date 2023-04-20 16:09
 * @desc GridGroupLandService接口
 */
public interface GridGroupLandService extends BaseService<GridGroupLand, GridGroupLandExample> {

    PageInfo<GridGroupExt> page(Integer pageNo, Integer pageSize, String groupName);

    AjaxResult saveOrUpdate(GridGroupExt wsGroupExt);

    void delete(String groupId);

    GridGroupExt detail(String groupId);

    String sumlandAreaTotal(List<String> landIds);

    List<Map<String, String>> getRelatedCompanyList(List<String> landIds);

    List<Map<String, String>> permuSortList(String year);

}
