package com.ruoyi.system.domain.visit.enums;


/**
 * * Author: brenda
 * * 2024/6/20
 **/
public enum VisitTypeEnum {

    FREE_VISIT("F","自由走访"),

    UPDATE_VISIT("U","更新走访");

    private String code;

    private String value;

    private VisitTypeEnum(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public static VisitTypeEnum getByCode(String code) {
        if (code == null || code.trim().length() <= 0) {
            return null;
        }
        for (int i = 0; i < values().length; i++) {
            if (values()[i].code.equals(code)) {
                return values()[i];
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
